/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Objects;
import java.util.Vector;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.image.internal.shared.TileErrorHandler;
import org.apache.sis.image.internal.shared.TileOpExecutor;
import org.apache.sis.image.internal.shared.TilePlaceholder;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.resources.Errors;

final class PrefetchedImage
extends PlanarImage
implements TileErrorHandler.Executor {
    final RenderedImage source;
    private final int minTileX;
    private final int minTileY;
    private final int numXTiles;
    private final int numYTiles;
    private final Raster[] tiles;
    private volatile TilePlaceholder placeholderPixels;
    private ErrorHandler.Report errorReport;

    PrefetchedImage(RenderedImage source, Rectangle areaOfInterest, ErrorHandler errorHandler, boolean parallel) {
        this.source = source;
        if (areaOfInterest != null) {
            areaOfInterest = new Rectangle(areaOfInterest);
            ImageUtilities.clipBounds(source, areaOfInterest);
            if (areaOfInterest.isEmpty()) {
                this.minTileX = 0;
                this.minTileY = 0;
                this.numXTiles = 0;
                this.numYTiles = 0;
                this.tiles = null;
                return;
            }
        }
        Worker worker = new Worker(source, areaOfInterest);
        Rectangle ti = worker.getTileIndices();
        this.minTileX = ti.x;
        this.minTileY = ti.y;
        this.numXTiles = ti.width;
        this.numYTiles = ti.height;
        this.tiles = new Raster[Math.multiplyExact(this.numYTiles, this.numXTiles)];
        worker.setErrorHandler(errorHandler, ImageProcessor.class, "prefetch");
        Disposable ph = source instanceof PlanarImage ? ((PlanarImage)source).prefetch(ti) : null;
        try {
            if (parallel) {
                worker.parallelReadFrom(source);
            } else {
                worker.readFrom(source);
            }
        }
        finally {
            if (ph != null) {
                ph.dispose();
            }
        }
        for (int i = 0; i < this.tiles.length; ++i) {
            if (this.tiles[i] != null) continue;
            int tileX = i % this.numXTiles + this.minTileX;
            int tileY = i / this.numXTiles + this.minTileY;
            this.tiles[i] = this.createPlaceholder(tileX, tileY);
        }
    }

    final boolean isEmpty() {
        return (this.numXTiles | this.numYTiles) == 0;
    }

    @Override
    public Vector<RenderedImage> getSources() {
        Vector<RenderedImage> sources = new Vector<RenderedImage>(1);
        sources.add(this.source);
        return sources;
    }

    @Override
    public Object getProperty(String name) {
        return this.source.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.source.getPropertyNames();
    }

    @Override
    public ColorModel getColorModel() {
        return this.source.getColorModel();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.source.getSampleModel();
    }

    @Override
    public int getWidth() {
        return this.source.getWidth();
    }

    @Override
    public int getHeight() {
        return this.source.getHeight();
    }

    @Override
    public int getMinX() {
        return this.source.getMinX();
    }

    @Override
    public int getMinY() {
        return this.source.getMinY();
    }

    @Override
    public int getNumXTiles() {
        return this.source.getNumXTiles();
    }

    @Override
    public int getNumYTiles() {
        return this.source.getNumYTiles();
    }

    @Override
    public int getMinTileX() {
        return this.source.getMinTileX();
    }

    @Override
    public int getMinTileY() {
        return this.source.getMinTileY();
    }

    @Override
    public int getTileWidth() {
        return this.source.getTileWidth();
    }

    @Override
    public int getTileHeight() {
        return this.source.getTileHeight();
    }

    @Override
    public int getTileGridXOffset() {
        return this.source.getTileGridXOffset();
    }

    @Override
    public int getTileGridYOffset() {
        return this.source.getTileGridYOffset();
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        int ty;
        int tx = Math.subtractExact(tileX, this.minTileX);
        if (tx >= 0 && tileX < this.numXTiles && (ty = Math.subtractExact(tileY, this.minTileY)) >= 0 && tileY < this.numYTiles) {
            return this.tiles[tx + ty * this.numXTiles];
        }
        try {
            return this.source.getTile(tileX, tileY);
        }
        catch (RuntimeException e) {
            ErrorHandler.Report report = this.errorReport;
            if (report == null) {
                throw e;
            }
            report.add(new Point(tileX, tileY), e, null);
            assert (Thread.holdsLock(this));
            return this.createPlaceholder(tileX, tileY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(Runnable action, TileErrorHandler errorHandler) {
        ArgumentChecks.ensureNonNull((String)"action", (Object)action);
        ArgumentChecks.ensureNonNull((String)"errorHandler", (Object)errorHandler);
        this.errorReport = new ErrorHandler.Report();
        try {
            action.run();
        }
        finally {
            ErrorHandler.Report report = this.errorReport;
            this.errorReport = null;
            errorHandler.publish(report);
        }
    }

    private Raster createPlaceholder(int tileX, int tileY) {
        TilePlaceholder p = this.placeholderPixels;
        if (p == null) {
            this.placeholderPixels = p = TilePlaceholder.withCross(this.source);
        }
        return p.create(new Point(ImageUtilities.tileToPixelX(this.source, tileX), ImageUtilities.tileToPixelY(this.source, tileY)));
    }

    public int hashCode() {
        return Objects.hash(this.source, this.minTileX, this.minTileY, this.numXTiles, this.numYTiles);
    }

    public boolean equals(Object object) {
        if (object instanceof PrefetchedImage) {
            PrefetchedImage other = (PrefetchedImage)object;
            return this.source.equals(other.source) && this.minTileX == other.minTileX && this.minTileY == other.minTileY && this.numXTiles == other.numXTiles && this.numYTiles == other.numYTiles;
        }
        return false;
    }

    private final class Worker
    extends TileOpExecutor {
        private final long tileWidth;
        private final long tileHeight;
        private final long tileGridXOffset;
        private final long tileGridYOffset;

        Worker(RenderedImage source, Rectangle aoi) {
            super(source, aoi);
            this.tileWidth = source.getTileWidth();
            this.tileHeight = source.getTileHeight();
            this.tileGridXOffset = source.getTileGridXOffset();
            this.tileGridYOffset = source.getTileGridYOffset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readFrom(Raster source) {
            long tx = Math.floorDiv((long)source.getMinX() - this.tileGridXOffset, this.tileWidth) - (long)PrefetchedImage.this.minTileX;
            long ty = Math.floorDiv((long)source.getMinY() - this.tileGridYOffset, this.tileHeight) - (long)PrefetchedImage.this.minTileY;
            assert (tx >= 0L && tx < (long)PrefetchedImage.this.numXTiles) : tx;
            assert (ty >= 0L && ty < (long)PrefetchedImage.this.numYTiles) : ty;
            int index = Math.toIntExact(tx + ty * (long)PrefetchedImage.this.numXTiles);
            Raster[] rasterArray = PrefetchedImage.this.tiles;
            synchronized (PrefetchedImage.this.tiles) {
                if (PrefetchedImage.this.tiles[index] != null) {
                    throw new RasterFormatException(Errors.format((short)37, (Object)("Tile[" + tx + ", " + ty + "]")));
                }
                PrefetchedImage.this.tiles[index] = source;
                // ** MonitorExit[var7_5] (shouldn't be in output)
                return;
            }
        }
    }
}

