/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.internal.shared;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.internal.shared.ExceptionSimplifier;
import org.apache.sis.xml.internal.shared.URISource;

public class ExternalLinkHandler {
    public static final ExternalLinkHandler DEFAULT = new ExternalLinkHandler((String)null);
    private Object base;
    private String fragment;

    public ExternalLinkHandler(String sibling) {
        this.base = sibling;
    }

    public ExternalLinkHandler(File sibling) {
        this.base = sibling;
    }

    public ExternalLinkHandler(URL sibling) {
        this.base = sibling;
        this.fragment = sibling.getRef();
    }

    public ExternalLinkHandler(Source sibling) {
        if (sibling instanceof URISource) {
            URISource s = (URISource)sibling;
            this.base = s.document;
            this.fragment = s.fragment;
        } else {
            this.base = sibling.getSystemId();
        }
    }

    public ExternalLinkHandler(Result sibling) {
        this.base = sibling.getSystemId();
    }

    public final Object getBase() {
        return this.base;
    }

    public final String getFragment() {
        URI uri;
        if (this.fragment == null && (uri = this.getURI()) != null) {
            this.fragment = uri.getFragment();
        }
        return this.fragment;
    }

    public final URI getURI() {
        URI baseURI;
        Object b = this.base;
        if (b == null) {
            return null;
        }
        if (b instanceof URI) {
            baseURI = (URI)b;
        } else {
            block8: {
                this.base = null;
                try {
                    if (b instanceof String) {
                        baseURI = new URI((String)b);
                        break block8;
                    }
                    if (b instanceof URL) {
                        baseURI = ((URL)b).toURI();
                        break block8;
                    }
                    if (b instanceof File) {
                        baseURI = ((File)b).toURI();
                        break block8;
                    }
                    return null;
                }
                catch (URISyntaxException e) {
                    ExternalLinkHandler.warningOccured(b, e);
                    return null;
                }
            }
            baseURI = baseURI.normalize();
            this.base = baseURI;
        }
        return baseURI;
    }

    final URI resolve(URI path) {
        URI baseURI = this.getURI();
        if (baseURI != null) {
            return baseURI.resolve(path);
        }
        return path.isAbsolute() ? path : null;
    }

    public static void warningOccured(Object href, Exception cause) {
        new ExceptionSimplifier(href, cause).report(Context.current(), ReferenceResolver.class, "resolve");
    }

    public Source openReader(URI path) throws Exception {
        return (path = this.resolve(path)) != null ? new URISource(path) : null;
    }

    public static ExternalLinkHandler forStream(Object input) {
        return null;
    }

    public static ExternalLinkHandler create(XMLStreamReader input) {
        return ExternalLinkHandler.forStAX(input.getProperty("javax.xml.stream.resolver"), input.getLocation());
    }

    public static ExternalLinkHandler create(XMLEventReader input) throws XMLStreamException {
        return ExternalLinkHandler.forStAX(input.getProperty("javax.xml.stream.resolver"), input.peek().getLocation());
    }

    private static ExternalLinkHandler forStAX(Object property, Location location) {
        String base;
        if (location == null || (base = location.getSystemId()) == null) {
            return null;
        }
        if (!(property instanceof XMLResolver)) {
            return new ExternalLinkHandler(base);
        }
        final XMLResolver resolver = (XMLResolver)property;
        return new ExternalLinkHandler(base){

            @Override
            public Source openReader(URI path) throws Exception {
                Object source = resolver.resolveEntity(null, path.toString(), base, null);
                if (source == null || source instanceof Source) {
                    return (Source)source;
                }
                if (source instanceof XMLEventReader) {
                    return new StAXSource((XMLEventReader)source);
                }
                if (source instanceof XMLStreamReader) {
                    return new StAXSource((XMLStreamReader)source);
                }
                if (source instanceof InputStream) {
                    return URISource.create((InputStream)source, this.resolve(path));
                }
                throw new XMLStreamException(Errors.format((short)200, source.getClass()));
            }
        };
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"base", this.base});
    }
}

