/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.feature.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.Os;
import org.apache.sling.maven.feature.launcher.Launch;
import org.apache.sling.maven.feature.launcher.ProcessTracker;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartMojo
extends AbstractMojo {
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String JAVA_OPTS = "JAVA_OPTS";
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(required=true, defaultValue="1.3.4")
    private String featureLauncherVersion;
    @Parameter(required=true, defaultValue="true")
    private boolean trackProcess;
    @Parameter(required=true)
    private List<Launch> launches;
    @Parameter(defaultValue="${project.build.directory}/featureLauncherAttachedArtifacts", property="attachedArtifactsDirectory", required=true)
    private File attachedArtifactsDirectory;
    @Inject
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Inject
    private ProcessTracker processes;
    @Inject
    private ArchiverManager archiverManager;

    /*
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File launcher;
            VersionRange beforeAssemblyRange = VersionRange.createFromVersionSpec((String)"(,1.1.26]");
            boolean useAssembly = !beforeAssemblyRange.containsVersion((ArtifactVersion)new DefaultArtifactVersion(this.featureLauncherVersion));
            RepositorySystemSession repositorySession = this.mavenSession.getRepositorySession();
            File workDir = new File(this.outputDirectory, "launchers");
            workDir.mkdirs();
            this.createRepositoryWithAttachedArtifacts();
            if (useAssembly) {
                DefaultArtifact launcherAssemblyArtifact = new DefaultArtifact("org.apache.sling:org.apache.sling.feature.launcher:tar.gz:" + this.featureLauncherVersion);
                File assemblyArchive = this.resolver.resolveArtifact(repositorySession, new ArtifactRequest((org.eclipse.aether.artifact.Artifact)launcherAssemblyArtifact, this.remoteRepos, null)).getArtifact().getFile();
                UnArchiver unArchiver = this.archiverManager.getUnArchiver(assemblyArchive);
                unArchiver.setSourceFile(assemblyArchive);
                unArchiver.setDestFile(workDir);
                unArchiver.extract();
                Path relPath = Paths.get(launcherAssemblyArtifact.getArtifactId() + "-" + launcherAssemblyArtifact.getVersion(), "bin");
                relPath = Os.isFamily((String)"windows") ? relPath.resolve("launcher.bat") : relPath.resolve("launcher");
                launcher = workDir.toPath().resolve(relPath).toFile();
            } else {
                DefaultArtifact launcherArtifact = new DefaultArtifact("org.apache.sling:org.apache.sling.feature.launcher:" + this.featureLauncherVersion);
                launcher = this.resolver.resolveArtifact(repositorySession, new ArtifactRequest((org.eclipse.aether.artifact.Artifact)launcherArtifact, this.remoteRepos, null)).getArtifact().getFile();
            }
            for (Launch launch : this.launches) {
                Object javaOptsBuilder;
                if (launch.isSkip()) {
                    this.getLog().info((CharSequence)("Skipping starting launch with id " + launch.getId()));
                    continue;
                }
                launch.validate();
                File featureFile = launch.getFeature().map(this::toArtifact).map(a -> this.uncheckedResolveArtifact(repositorySession, (org.eclipse.aether.artifact.Artifact)a)).map(r -> r.getArtifact().getFile()).orElseGet(() -> launch.getFeatureFile().get());
                String javahome = System.getenv(JAVA_HOME);
                if (javahome == null || javahome.isEmpty()) {
                    this.getLog().warn((CharSequence)"The JAVA_HOME env variable was not set, falling back to the java.home system property");
                    javahome = System.getProperty("java.home");
                }
                ArrayList<String> args = new ArrayList<String>();
                if (useAssembly) {
                    HashMap<String, String> newEnv = new HashMap<String, String>(launch.getEnvironmentVariables());
                    newEnv.put(JAVA_HOME, javahome);
                    javaOptsBuilder = null;
                    String[] vmOptions2 = launch.getLauncherArguments().getVmOptions();
                    for (String vmOption : vmOptions2) {
                        if (vmOption == null || vmOption.isEmpty()) continue;
                        if (javaOptsBuilder == null) {
                            javaOptsBuilder = new StringBuilder();
                        } else {
                            ((StringBuilder)javaOptsBuilder).append(" ");
                        }
                        ((StringBuilder)javaOptsBuilder).append(vmOption);
                    }
                    if (javaOptsBuilder != null) {
                        if (newEnv.containsKey(JAVA_OPTS)) {
                            ((StringBuilder)javaOptsBuilder).append(" ").append((String)newEnv.get(JAVA_OPTS));
                        }
                        newEnv.put(JAVA_OPTS, ((StringBuilder)javaOptsBuilder).toString());
                    }
                    args.add(launcher.getAbsolutePath());
                    launch.setEnvironmentVariables(newEnv);
                } else {
                    void var14_20;
                    args.add(javahome + File.separatorChar + "bin" + File.separatorChar + "java");
                    String[] vmOptions = launch.getLauncherArguments().getVmOptions();
                    javaOptsBuilder = vmOptions;
                    int vmOptions2 = ((String[])javaOptsBuilder).length;
                    boolean bl = false;
                    while (var14_20 < vmOptions2) {
                        String vmOption = javaOptsBuilder[var14_20];
                        if (vmOption != null && !vmOption.isEmpty()) {
                            args.add(vmOption);
                        }
                        ++var14_20;
                    }
                    args.add("-jar");
                    args.add(launcher.getAbsolutePath());
                }
                ArrayList<String> repositoryUrls = new ArrayList<String>();
                repositoryUrls.add(this.attachedArtifactsDirectory.toURI().toString());
                if (launch.getRepositoryUrls() != null && !launch.getRepositoryUrls().isEmpty()) {
                    repositoryUrls.addAll(launch.getRepositoryUrls());
                } else {
                    repositoryUrls.add(new File(this.localRepository.getBasedir()).toURI().toString());
                    repositoryUrls.add("https://repo1.maven.org/maven2");
                    repositoryUrls.add("https://repository.apache.org/content/group/snapshots");
                }
                args.add("-u");
                StringJoiner joiner = new StringJoiner(",");
                repositoryUrls.forEach(joiner::add);
                args.add(joiner.toString());
                args.add("-f");
                args.add(featureFile.getAbsolutePath());
                args.add("-p");
                args.add(launch.getId());
                for (Map.Entry entry : launch.getLauncherArguments().getFrameworkProperties().entrySet()) {
                    args.add("-D");
                    args.add((String)entry.getKey() + "=" + (String)entry.getValue());
                }
                for (Map.Entry entry : launch.getLauncherArguments().getVariables().entrySet()) {
                    args.add("-V");
                    args.add((String)entry.getKey() + "=" + (String)entry.getValue());
                }
                ProcessBuilder pb = new ProcessBuilder(args);
                pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
                pb.directory(workDir);
                launch.getEnvironmentVariables().entrySet().forEach(e -> {
                    this.getLog().info((CharSequence)("Setting environment variable '" + (String)e.getKey() + "' to '" + (String)e.getValue() + "'"));
                    pb.environment().put((String)e.getKey(), (String)e.getValue());
                });
                this.getLog().info((CharSequence)("Starting launch with id '" + launch.getId() + "', args=" + String.valueOf(args)));
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                final Process process = pb.start();
                Thread monitor = new Thread("launch-monitor-" + launch.getId()){

                    @Override
                    public void run() {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                System.out.println(line);
                                if (!line.contains("Framework started")) continue;
                                countDownLatch.countDown();
                                break;
                            }
                        }
                        catch (IOException e) {
                            StartMojo.this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
                        }
                    }
                };
                monitor.start();
                this.getLog().info((CharSequence)("Waiting for " + launch.getId() + " to start"));
                boolean started = countDownLatch.await(launch.getStartTimeoutSeconds(), TimeUnit.SECONDS);
                if (!started) {
                    ProcessTracker.stop(process);
                    throw new MojoExecutionException("Launch " + launch.getId() + " failed to start in " + launch.getStartTimeoutSeconds() + " seconds.");
                }
                if (!this.trackProcess) continue;
                this.processes.startTracking(launch.getId(), process);
            }
        }
        catch (IOException | InvalidVersionSpecificationException | NoSuchArchiverException | ArtifactResolutionException e2) {
            throw new MojoExecutionException(e2.getMessage(), (Exception)e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("Execution interrupted", (Exception)e3);
        }
    }

    private ArtifactResult uncheckedResolveArtifact(RepositorySystemSession repositorySession, org.eclipse.aether.artifact.Artifact artifact) {
        try {
            return this.resolver.resolveArtifact(repositorySession, new ArtifactRequest(artifact, this.remoteRepos, null));
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e);
        }
    }

    private org.eclipse.aether.artifact.Artifact toArtifact(Dependency dependency) {
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
    }

    private void createRepositoryWithAttachedArtifacts() throws IOException {
        Path tempRepo = this.attachedArtifactsDirectory.toPath();
        if (Files.exists(tempRepo, new LinkOption[0])) {
            this.getLog().info((CharSequence)("Deleting existing attached artifact repository at: " + String.valueOf(tempRepo)));
            FileUtils.deleteDirectory((File)tempRepo.toFile());
        }
        this.getLog().info((CharSequence)("Created attached artifact repository at: " + String.valueOf(tempRepo)));
        Artifact mainArtifact = this.project.getArtifact();
        if (mainArtifact != null && mainArtifact.getFile() != null && mainArtifact.getFile().exists()) {
            this.copyArtifactToRepository(mainArtifact, tempRepo);
        }
        for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
            if (attachedArtifact.getFile() == null || !attachedArtifact.getFile().exists()) continue;
            this.copyArtifactToRepository(attachedArtifact, tempRepo);
        }
    }

    private void copyArtifactToRepository(Artifact artifact, Path repoPath) throws IOException {
        String groupPath = artifact.getGroupId().replace('.', '/');
        Path artifactDir = repoPath.resolve(groupPath).resolve(artifact.getArtifactId()).resolve(artifact.getVersion());
        Files.createDirectories(artifactDir, new FileAttribute[0]);
        StringBuilder filename = new StringBuilder();
        filename.append(artifact.getArtifactId()).append("-").append(artifact.getVersion());
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            filename.append("-").append(artifact.getClassifier());
        }
        String extension = artifact.getType();
        if (artifact.getArtifactHandler() != null && artifact.getArtifactHandler().getExtension() != null) {
            extension = artifact.getArtifactHandler().getExtension();
        }
        filename.append(".").append(extension);
        Path targetFile = artifactDir.resolve(filename.toString());
        Files.copy(artifact.getFile().toPath(), targetFile, new CopyOption[0]);
        this.getLog().debug((CharSequence)("Copied artifact " + String.valueOf(artifact) + " to " + String.valueOf(targetFile)));
    }
}

