/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.factory.ModelClassException;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.RequestAttributeInjector;
import org.apache.sling.models.impl.injectors.SelfInjector;
import org.apache.sling.models.impl.via.BeanPropertyViaProvider;
import org.apache.sling.models.spi.ViaProvider;
import org.apache.sling.models.testmodels.classes.InvalidConstructorModel;
import org.apache.sling.models.testmodels.classes.SuperclassConstructorModel;
import org.apache.sling.models.testmodels.classes.WithOneConstructorModel;
import org.apache.sling.models.testmodels.classes.WithThreeConstructorsModel;
import org.apache.sling.models.testmodels.classes.WithTwoConstructorsModel;
import org.apache.sling.models.testmodels.classes.constructorinjection.NoNameModel;
import org.apache.sling.models.testmodels.classes.constructorinjection.ViaRequestSuffixModel;
import org.apache.sling.models.testmodels.classes.constructorinjection.WithThreeConstructorsOneInjectModel;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ConstructorTest {
    private ModelAdapterFactory factory;
    @Mock
    private SlingJakartaHttpServletRequest request;
    private static final int INT_VALUE = 42;
    private static final String STRING_VALUE = "myValue";

    ConstructorTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.lenient().when(this.request.getAttribute("attribute")).thenReturn((Object)42);
        Mockito.lenient().when(this.request.getAttribute("attribute2")).thenReturn((Object)STRING_VALUE);
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new RequestAttributeInjector(), new SelfInjector());
        this.factory.bindViaProvider((ViaProvider)new BeanPropertyViaProvider(), null);
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{WithOneConstructorModel.class, WithThreeConstructorsModel.class, WithTwoConstructorsModel.class, SuperclassConstructorModel.class, InvalidConstructorModel.class, WithThreeConstructorsOneInjectModel.class, NoNameModel.class, ViaRequestSuffixModel.class});
    }

    @Test
    void testConstructorInjection() {
        WithOneConstructorModel model = (WithOneConstructorModel)this.factory.getAdapter((Object)this.request, WithOneConstructorModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)this.request, (Object)model.getRequest());
        Assertions.assertEquals((int)42, (int)model.getAttribute());
    }

    @Test
    void testThreeConstructorsInjection() {
        WithThreeConstructorsModel model = (WithThreeConstructorsModel)this.factory.getAdapter((Object)this.request, WithThreeConstructorsModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)this.request, (Object)model.getRequest());
        Assertions.assertEquals((int)42, (int)model.getAttribute());
    }

    @Test
    void testTwoConstructorsInjection() {
        WithTwoConstructorsModel model = (WithTwoConstructorsModel)this.factory.getAdapter((Object)this.request, WithTwoConstructorsModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)this.request, (Object)model.getRequest());
        Assertions.assertEquals((int)42, (int)model.getAttribute());
    }

    @Test
    void testSuperclassConstructorsInjection() {
        SuperclassConstructorModel model = (SuperclassConstructorModel)this.factory.getAdapter((Object)this.request, SuperclassConstructorModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)this.request, (Object)model.getRequest());
        Assertions.assertEquals((int)42, (int)model.getAttribute());
    }

    @Test
    void testInvalidConstructorInjector() {
        InvalidConstructorModel model = (InvalidConstructorModel)this.factory.getAdapter((Object)this.request, InvalidConstructorModel.class);
        Assertions.assertNull((Object)model);
    }

    @Test
    void testInvalidConstructorInjectorException() {
        Assertions.assertThrows(ModelClassException.class, () -> this.factory.createModel((Object)this.request, InvalidConstructorModel.class));
    }

    @Test
    void testThreeConstructorsOneInjectInjection() {
        WithThreeConstructorsOneInjectModel model = (WithThreeConstructorsOneInjectModel)this.factory.getAdapter((Object)this.request, WithThreeConstructorsOneInjectModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertNull((Object)model.getRequest());
        Assertions.assertEquals((int)42, (int)model.getAttribute());
        Assertions.assertEquals((Object)STRING_VALUE, (Object)model.getAttribute2());
    }

    @Test
    void testMultiThreadedConstructorInjection() throws InterruptedException, ExecutionException {
        int tries = 10000;
        int threads = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        class ModelCreator
        implements Callable<String> {
            ModelCreator() {
            }

            @Override
            public String call() throws Exception {
                try {
                    WithOneConstructorModel model = (WithOneConstructorModel)ConstructorTest.this.factory.getAdapter((Object)ConstructorTest.this.request, WithOneConstructorModel.class);
                    if (model == null) {
                        return "Expected model not null";
                    }
                    if (!ConstructorTest.this.request.equals((Object)model.getRequest())) {
                        return "Expected same request";
                    }
                    if (42 != model.getAttribute()) {
                        return "Expected same value for attribute";
                    }
                }
                catch (Throwable e) {
                    return "Exception not expected: " + String.valueOf(e);
                }
                return null;
            }
        }
        ArrayList<ModelCreator> modelCreators = new ArrayList<ModelCreator>(tries);
        for (int i = 0; i < tries; ++i) {
            modelCreators.add(new ModelCreator());
        }
        List futures = executorService.invokeAll(modelCreators);
        executorService.shutdown();
        for (Future f : futures) {
            String res = (String)f.get();
            if (res == null) continue;
            Assertions.fail((String)res);
        }
    }

    @Test
    void testNoNameModel() {
        NoNameModel model = (NoNameModel)this.factory.getAdapter((Object)this.request, NoNameModel.class);
        Assertions.assertNull((Object)model);
    }

    @Test
    void testViaInjectionModel() {
        Resource suffixResource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)suffixResource.getPath()).thenReturn((Object)"/the/suffix");
        RequestPathInfo requestPathInfo = (RequestPathInfo)Mockito.mock(RequestPathInfo.class);
        Mockito.when((Object)requestPathInfo.getSuffixResource()).thenReturn((Object)suffixResource);
        Mockito.when((Object)this.request.getRequestPathInfo()).thenReturn((Object)requestPathInfo);
        ViaRequestSuffixModel model = (ViaRequestSuffixModel)this.factory.getAdapter((Object)this.request, ViaRequestSuffixModel.class);
        MatcherAssert.assertThat((Object)model, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)model.getSuffix(), (Matcher)Matchers.is((Object)"/the/suffix"));
    }
}

