/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it.testing;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.models.it.testbundle.models.ConstructorInjectionTestModel;
import org.apache.sling.models.it.testbundle.models.FieldInjectionTestModel;
import org.apache.sling.models.it.testbundle.models.implextend.InvalidImplementsInterfacePropertyModel;
import org.apache.sling.models.it.testbundle.models.implextend.SampleServiceInterface;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class ModelFactorySimpleIT {
    @Rule
    public final TeleporterRule teleporter = TeleporterRule.forClass(this.getClass(), (String)"SM_Teleporter");
    private ModelFactory modelFactory;
    private String value;
    private ResourceResolver resolver;
    private Resource resource;
    private Node createdNode;

    @Before
    public void setUp() throws Exception {
        ResourceResolverFactory rrFactory = (ResourceResolverFactory)this.teleporter.getService(ResourceResolverFactory.class);
        this.modelFactory = (ModelFactory)this.teleporter.getService(ModelFactory.class);
        this.value = RandomStringUtils.secure().nextAlphanumeric(10);
        this.resolver = rrFactory.getServiceResourceResolver(null);
        Session session = (Session)this.resolver.adaptTo(Session.class);
        Node rootNode = session.getRootNode();
        this.createdNode = rootNode.addNode("test_" + RandomStringUtils.secure().nextAlphanumeric(10));
        this.createdNode.setProperty("testProperty", this.value);
        session.save();
        this.resource = this.resolver.getResource(this.createdNode.getPath());
    }

    @After
    public void tearDown() throws Exception {
        if (this.createdNode != null) {
            this.createdNode.remove();
        }
        if (this.resolver != null) {
            this.resolver.close();
        }
    }

    @Test
    public void testCreateModel() {
        FieldInjectionTestModel model = (FieldInjectionTestModel)this.modelFactory.createModel((Object)this.resource, FieldInjectionTestModel.class);
        Assert.assertNotNull((String)"Model is null", (Object)model);
        Assert.assertEquals((String)"Test Property is not set correctly", (Object)this.value, (Object)model.getTestProperty());
        Assert.assertNotNull((String)"Filters is null", model.getFilters());
        Assert.assertSame((String)"Adaptable is not injected", (Object)this.resource, (Object)model.getResource());
    }

    @Test
    public void testIsModelClass() {
        Assert.assertTrue((String)"Model is not detected as such", (boolean)this.modelFactory.isModelClass(ConstructorInjectionTestModel.class));
        Assert.assertFalse((String)"Dummy class incorrectly detected as model class", (boolean)this.modelFactory.isModelClass(DummyClass.class));
        Assert.assertFalse((String)"Model with invalid adaptable incorrectly detected as model class", (boolean)this.modelFactory.isModelClass(InvalidImplementsInterfacePropertyModel.class));
        Assert.assertTrue((String)"Model is not detected as such", (boolean)this.modelFactory.isModelClass(SampleServiceInterface.class));
    }

    @Test
    public void testCanCreateFromAdaptable() {
        Assert.assertTrue((String)"Model is not detected as such", (boolean)this.modelFactory.canCreateFromAdaptable((Object)this.resource, ConstructorInjectionTestModel.class));
        Assert.assertTrue((String)"Model is not detected as such", (boolean)this.modelFactory.canCreateFromAdaptable((Object)this.resource, SampleServiceInterface.class));
        Assert.assertFalse((String)"Model is incorrectly detected", (boolean)this.modelFactory.canCreateFromAdaptable((Object)new String(), ConstructorInjectionTestModel.class));
    }

    @Test
    public void testCanCreateFromAdaptableWithModelExceptin() {
        Assert.assertFalse((String)"Model is incorrectly detected", (boolean)this.modelFactory.canCreateFromAdaptable((Object)this.resource, DummyClass.class));
    }

    @Ignore
    private static final class DummyClass {
        private DummyClass() {
        }
    }
}

