/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.commons.cnd.DefinitionBuilderFactory;
import org.apache.sling.testing.mock.jcr.MockNodeDefinitionTemplate;
import org.apache.sling.testing.mock.jcr.MockPropertyDefinitionTemplate;

class MockTemplateBuilderFactory
extends DefinitionBuilderFactory<NodeTypeTemplate, NamespaceRegistry> {
    private final NodeTypeManager nodeTypeManager;
    private final ValueFactory valueFactory;
    private NamespaceRegistry namespaceRegistry;

    public MockTemplateBuilderFactory(NodeTypeManager nodeTypeManager, ValueFactory valueFactory, NamespaceRegistry namespaceRegistry) {
        this.nodeTypeManager = nodeTypeManager;
        this.valueFactory = valueFactory;
        this.namespaceRegistry = namespaceRegistry;
    }

    public MockTemplateBuilderFactory(Session session) throws RepositoryException {
        this(session.getWorkspace().getNodeTypeManager(), session.getValueFactory(), session.getWorkspace().getNamespaceRegistry());
    }

    public DefinitionBuilderFactory.AbstractNodeTypeDefinitionBuilder<NodeTypeTemplate> newNodeTypeDefinitionBuilder() throws RepositoryException {
        return new NodeTypeTemplateBuilder();
    }

    public void setNamespaceMapping(NamespaceRegistry namespaceRegistry) {
        this.namespaceRegistry = namespaceRegistry;
    }

    public NamespaceRegistry getNamespaceMapping() {
        return this.namespaceRegistry;
    }

    public void setNamespace(String prefix, String uri) {
        try {
            this.namespaceRegistry.registerNamespace(prefix, uri);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public class NodeTypeTemplateBuilder
    extends DefinitionBuilderFactory.AbstractNodeTypeDefinitionBuilder<NodeTypeTemplate> {
        private final NodeTypeTemplate template;
        private final List<String> supertypes = new ArrayList<String>();

        public NodeTypeTemplateBuilder() throws RepositoryException {
            this.template = MockTemplateBuilderFactory.this.nodeTypeManager.createNodeTypeTemplate();
        }

        public DefinitionBuilderFactory.AbstractNodeDefinitionBuilder<NodeTypeTemplate> newNodeDefinitionBuilder() throws RepositoryException {
            return new NodeDefinitionTemplateBuilder(this);
        }

        public DefinitionBuilderFactory.AbstractPropertyDefinitionBuilder<NodeTypeTemplate> newPropertyDefinitionBuilder() throws RepositoryException {
            return new PropertyDefinitionTemplateBuilder(this);
        }

        public NodeTypeTemplate build() throws ConstraintViolationException {
            this.template.setMixin(this.isMixin);
            this.template.setOrderableChildNodes(this.isOrderable);
            this.template.setAbstract(this.isAbstract);
            this.template.setQueryable(this.queryable);
            this.template.setDeclaredSuperTypeNames(this.supertypes.toArray(new String[this.supertypes.size()]));
            return this.template;
        }

        public void setName(String name) throws RepositoryException {
            super.setName(name);
            this.template.setName(name);
        }

        public void addSupertype(String name) {
            this.supertypes.add(name);
        }

        public void setPrimaryItemName(String name) throws ConstraintViolationException {
            this.template.setPrimaryItemName(name);
        }
    }

    public class NodeDefinitionTemplateBuilder
    extends DefinitionBuilderFactory.AbstractNodeDefinitionBuilder<NodeTypeTemplate> {
        private final NodeTypeTemplateBuilder ntd;
        private final NodeDefinitionTemplate template;
        private final List<String> requiredPrimaryTypes = new ArrayList<String>();

        public NodeDefinitionTemplateBuilder(NodeTypeTemplateBuilder ntd) throws RepositoryException {
            this.ntd = ntd;
            this.template = MockTemplateBuilderFactory.this.nodeTypeManager.createNodeDefinitionTemplate();
        }

        public void setName(String name) throws RepositoryException {
            super.setName(name);
            this.template.setName(name);
        }

        public void addRequiredPrimaryType(String name) {
            this.requiredPrimaryTypes.add(name);
        }

        public void setDefaultPrimaryType(String name) throws ConstraintViolationException {
            this.template.setDefaultPrimaryTypeName(name);
        }

        public void setDeclaringNodeType(String name) {
            if (this.template instanceof MockNodeDefinitionTemplate) {
                ((MockNodeDefinitionTemplate)this.template).setDeclaringNodeType(name);
            }
        }

        public void build() throws ConstraintViolationException {
            this.template.setAutoCreated(this.autocreate);
            this.template.setMandatory(this.isMandatory);
            this.template.setOnParentVersion(this.onParent);
            this.template.setProtected(this.isProtected);
            this.template.setRequiredPrimaryTypeNames(this.requiredPrimaryTypes.toArray(new String[this.requiredPrimaryTypes.size()]));
            this.template.setSameNameSiblings(this.allowSns);
            List templates = this.ntd.template.getNodeDefinitionTemplates();
            templates.add(this.template);
        }
    }

    public class PropertyDefinitionTemplateBuilder
    extends DefinitionBuilderFactory.AbstractPropertyDefinitionBuilder<NodeTypeTemplate> {
        private final NodeTypeTemplateBuilder ntd;
        private final PropertyDefinitionTemplate template;
        private final List<Value> values = new ArrayList<Value>();
        private final List<String> constraints = new ArrayList<String>();

        public PropertyDefinitionTemplateBuilder(NodeTypeTemplateBuilder ntd) throws RepositoryException {
            this.ntd = ntd;
            this.template = MockTemplateBuilderFactory.this.nodeTypeManager.createPropertyDefinitionTemplate();
        }

        public void setName(String name) throws RepositoryException {
            super.setName(name);
            this.template.setName(name);
        }

        public void addDefaultValues(String value) throws ValueFormatException {
            this.values.add(MockTemplateBuilderFactory.this.valueFactory.createValue(value, this.getRequiredType()));
        }

        public void addValueConstraint(String constraint) {
            this.constraints.add(constraint);
        }

        public void setDeclaringNodeType(String name) {
            if (this.template instanceof MockPropertyDefinitionTemplate) {
                ((MockPropertyDefinitionTemplate)this.template).setDeclaringNodeType(name);
            }
        }

        public void build() throws IllegalStateException {
            this.template.setAutoCreated(this.autocreate);
            this.template.setMandatory(this.isMandatory);
            this.template.setOnParentVersion(this.onParent);
            this.template.setProtected(this.isProtected);
            this.template.setRequiredType(this.requiredType);
            this.template.setValueConstraints(this.constraints.toArray(new String[this.constraints.size()]));
            this.template.setDefaultValues(this.values.toArray(new Value[this.values.size()]));
            this.template.setMultiple(this.isMultiple);
            this.template.setAvailableQueryOperators(this.queryOperators);
            this.template.setFullTextSearchable(this.fullTextSearchable);
            this.template.setQueryOrderable(this.queryOrderable);
            List templates = this.ntd.template.getPropertyDefinitionTemplates();
            templates.add(this.template);
        }
    }
}

