/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.apache.sling.testing.mock.sling.loader.AbstractContentLoaderBinaryTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractContentLoaderFolderJsonTest {
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());

    protected abstract ResourceResolverType getResourceResolverType();

    @Before
    public void setUp() {
        this.context.load().folderJson("src/test/resources/json-import-samples", "/mount");
        this.context.load().folderJson("src/test/resources/json-import-samples/apps", "/apps");
    }

    @After
    public final void tearDown() throws Exception {
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
    }

    @Test
    public void testContentResourceType() {
        Resource resource = this.context.resourceResolver().getResource("/mount/content/jcr:content");
        Assert.assertEquals((Object)"sample/components/homepage", (Object)resource.getResourceType());
    }

    @Test
    public void testContentListChildren() {
        Resource resource = this.context.resourceResolver().getResource("/mount/content");
        List result = IteratorUtils.toList((Iterator)resource.listChildren());
        Assert.assertEquals((Object)"jcr:content", (Object)((Resource)result.get(0)).getName());
        Assert.assertEquals((Object)"toolbar", (Object)((Resource)result.get(1)).getName());
    }

    @Test
    public void testDamResourceType() {
        Resource resource = this.context.resourceResolver().getResource("/mount/dam/portraits/scott_reynolds.jpg");
        Assert.assertEquals((Object)"dam:Asset", (Object)resource.getResourceType());
    }

    @Test
    public void testBinaryResource() throws IOException {
        Resource fileResource = this.context.resourceResolver().getResource("/mount/binary/sample-image.gif");
        AbstractContentLoaderBinaryTest.assertSampleImageFileSize(fileResource);
    }

    @Test
    public void testAppsResource() {
        Resource resource = this.context.resourceResolver().getResource("/apps/app1/components/comp1");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"Component #1", (Object)resource.getValueMap().get("jcr:title", String.class));
    }

    @Test
    public void testAppsResource_SearchPath() {
        Resource resource = this.context.resourceResolver().getResource("app1/components/comp1");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"Component #1", (Object)resource.getValueMap().get("jcr:title", String.class));
    }

    @Test
    public void testAppsResource_ParentResourceType() {
        Resource resource = this.context.resourceResolver().getResource("/mount/content/jcr:content/comp1-resource");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"app1/components/base", (Object)this.context.resourceResolver().getParentResourceType(resource));
        Assert.assertTrue((boolean)this.context.resourceResolver().isResourceType(resource, "app1/components/comp1"));
        Assert.assertTrue((boolean)this.context.resourceResolver().isResourceType(resource, "/apps/app1/components/comp1"));
        Assert.assertTrue((boolean)this.context.resourceResolver().isResourceType(resource, "app1/components/base"));
        Assert.assertTrue((boolean)this.context.resourceResolver().isResourceType(resource, "core/components/superResource"));
    }

    @Test
    public void testResourceOperationsOnMountedFolder() {
        String root = this.context.uniqueRoot().content() + "/test-content";
        this.context.load().folderJson("src/test/resources/test-content", root);
        Resource parent = this.context.resourceResolver().getResource(root + "/parent");
        Assert.assertNotNull((String)"Expected to resolve the 'parent' resource.", (Object)parent);
        Assert.assertNotNull((String)"Expected to resolver the 'child' resource.", (Object)parent.getChild("child"));
        Resource uniqueRoot = this.context.resourceResolver().getParent(parent);
        Assert.assertNotNull((String)"Expected to resolve the unique root.", (Object)uniqueRoot);
        Assert.assertEquals((String)"The resolved unique root is not identical to the created unique root.", (Object)root, (Object)uniqueRoot.getPath());
        Assert.assertTrue((String)"Expected to see a list of children.", (boolean)this.context.resourceResolver().listChildren(parent).hasNext());
        Assert.assertTrue((String)"Expected to get a list of children.", (boolean)this.context.resourceResolver().getChildren(parent).iterator().hasNext());
        Assert.assertTrue((String)"Expected to see a list of children.", (boolean)parent.hasChildren());
    }
}

