/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.datasource.socket.trident;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Map;
import org.apache.storm.task.IMetricsContext;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.state.StateFactory;

public class SocketState
implements State {
    private BufferedWriter out;

    public void beginCommit(Long txid) {
    }

    public void commit(Long txid) {
    }

    private SocketState(BufferedWriter out) {
        this.out = out;
    }

    public void write(String str) throws IOException {
        this.out.write(str);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public static class Factory
    implements StateFactory {
        private final String host;
        private final int port;

        public Factory(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public State makeState(Map conf, IMetricsContext metrics, int partitionIndex, int numPartitions) {
            BufferedWriter out;
            try {
                Socket socket = new Socket(this.host, this.port);
                out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while initializing socket for State. host " + this.host + " port " + this.port, e);
            }
            return new SocketState(out);
        }
    }
}

