/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.FileNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.MetaStoreFS;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;

public class HiveMetaStoreFsImpl
implements MetaStoreFS {
    public static final Log LOG = LogFactory.getLog((String)"hive.metastore.hivemetastoressimpl");

    @Override
    public boolean deleteDir(FileSystem fs, Path f, boolean recursive, boolean ifPurge, Configuration conf) throws MetaException {
        LOG.info((Object)("deleting  " + f));
        HadoopShims hadoopShim = ShimLoader.getHadoopShims();
        try {
            if (ifPurge) {
                LOG.info((Object)("Not moving " + f + " to trash"));
            } else if (hadoopShim.moveToAppropriateTrash(fs, f, conf)) {
                LOG.info((Object)("Moved to trash: " + f));
                return true;
            }
            if (fs.delete(f, true)) {
                LOG.info((Object)("Deleted the diretory " + f));
                return true;
            }
            if (fs.exists(f)) {
                throw new MetaException("Unable to delete directory: " + f);
            }
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (Exception e) {
            Warehouse.closeFs(fs);
            MetaStoreUtils.logAndThrowMetaException(e);
        }
        return false;
    }
}

