/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;

public class Permutation
implements Mapping,
Mappings.TargetMapping {
    private int[] targets;
    private int[] sources;

    public Permutation(int size) {
        this.targets = new int[size];
        this.sources = new int[size];
        this.identity();
    }

    public Permutation(int[] targets) {
        this.targets = (int[])targets.clone();
        this.sources = new int[targets.length];
        Arrays.fill(this.sources, -1);
        int i = 0;
        while (i < targets.length) {
            int target = targets[i];
            if (target < 0 || target >= this.sources.length) {
                throw new IllegalArgumentException("target out of range");
            }
            if (this.sources[target] != -1) {
                throw new IllegalArgumentException("more than one permutation element maps to position " + target);
            }
            this.sources[target] = i++;
        }
        assert (this.isValid(true));
    }

    private Permutation(int[] targets, int[] sources) {
        this.targets = targets;
        this.sources = sources;
        assert (this.isValid(true));
    }

    public Object clone() {
        return new Permutation((int[])this.targets.clone(), (int[])this.sources.clone());
    }

    public void identity() {
        for (int i = 0; i < this.targets.length; ++i) {
            this.targets[i] = this.sources[i] = i;
        }
    }

    @Override
    public final int size() {
        return this.targets.length;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot clear: permutation must always contain one mapping per element");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this.targets.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.targets[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void set(int source, int target) {
        this.set(source, target, false);
    }

    public void set(int source, int target, boolean allowResize) {
        int maxSourceTarget = Math.max(source, target);
        if (maxSourceTarget >= this.sources.length) {
            if (allowResize) {
                this.resize(maxSourceTarget + 1);
            } else {
                throw new ArrayIndexOutOfBoundsException(maxSourceTarget);
            }
        }
        int prevTarget = this.targets[source];
        assert (this.sources[prevTarget] == source);
        int prevSource = this.sources[target];
        assert (this.targets[prevSource] == target);
        this.setInternal(source, target);
        this.setInternal(prevSource, prevTarget);
    }

    public void insertTarget(int x) {
        assert (this.isValid(true));
        this.resize(this.sources.length + 1);
        this.shuffleUp(this.sources, x);
        this.increment(x, this.targets);
        assert (this.isValid(true));
    }

    public void insertSource(int x) {
        assert (this.isValid(true));
        this.resize(this.targets.length + 1);
        this.shuffleUp(this.targets, x);
        this.increment(x, this.sources);
        assert (this.isValid(true));
    }

    private void increment(int x, int[] zzz) {
        int size = zzz.length;
        for (int i = 0; i < size; ++i) {
            if (this.targets[i] == size - 1) {
                this.targets[i] = x;
                continue;
            }
            if (this.targets[i] < x) continue;
            int n = i;
            this.targets[n] = this.targets[n] + 1;
        }
    }

    private void shuffleUp(int[] zz, int x) {
        int size = zz.length;
        int t = zz[size - 1];
        System.arraycopy(zz, x, zz, x + 1, size - 1 - x);
        zz[x] = t;
    }

    private void resize(int newSize) {
        assert (this.isValid(true));
        int size = this.targets.length;
        int[] newTargets = new int[newSize];
        System.arraycopy(this.targets, 0, newTargets, 0, size);
        int[] newSources = new int[newSize];
        System.arraycopy(this.sources, 0, newSources, 0, size);
        for (int i = size; i < newSize; ++i) {
            newSources[i] = i;
            newTargets[i] = i;
        }
        this.targets = newTargets;
        this.sources = newSources;
        assert (this.isValid(true));
    }

    private void setInternal(int source, int target) {
        this.targets[source] = target;
        this.sources[target] = source;
    }

    @Override
    public Permutation inverse() {
        return new Permutation((int[])this.sources.clone(), (int[])this.targets.clone());
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] == i) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTarget(int source) {
        try {
            return this.targets[source];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new Mappings.NoElementException("invalid source " + source);
        }
    }

    @Override
    public int getSource(int target) {
        try {
            return this.sources[target];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new Mappings.NoElementException("invalid target " + target);
        }
    }

    private boolean isValid(boolean fail) {
        int size = this.targets.length;
        if (this.sources.length != size) {
            assert (!fail) : "different lengths";
            return false;
        }
        int[] occurCount = new int[size];
        for (int i = 0; i < size; ++i) {
            int target = this.targets[i];
            if (this.sources[target] != i) {
                assert (!fail) : "source[" + target + "] = " + this.sources[target] + ", should be " + i;
                return false;
            }
            int source = this.sources[i];
            if (this.targets[source] != i) {
                assert (!fail) : "target[" + source + "] = " + this.targets[source] + ", should be " + i;
                return false;
            }
            if (occurCount[target] == 0) continue;
            assert (!fail) : "target " + target + " occurs more than once";
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Permutation && this.toString().equals(obj.toString());
    }

    @Override
    public Iterator<IntPair> iterator() {
        return new Iterator<IntPair>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Permutation.this.targets.length;
            }

            @Override
            public IntPair next() {
                IntPair pair = new IntPair(this.i, Permutation.this.targets[this.i]);
                ++this.i;
                return pair;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int getSourceCount() {
        return this.targets.length;
    }

    @Override
    public int getTargetCount() {
        return this.targets.length;
    }

    @Override
    public MappingType getMappingType() {
        return MappingType.BIJECTION;
    }

    @Override
    public int getTargetOpt(int source) {
        return this.getTarget(source);
    }

    @Override
    public int getSourceOpt(int target) {
        return this.getSource(target);
    }

    public void setAll(Mapping mapping) {
        for (IntPair pair : mapping) {
            this.set(pair.source, pair.target);
        }
    }

    public Permutation product(Permutation permutation) {
        Permutation product = new Permutation(this.sources.length);
        for (int i = 0; i < this.targets.length; ++i) {
            product.set(i, permutation.getTarget(this.targets[i]));
        }
        return product;
    }
}

