/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.scostore.AbstractSetStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.scostore.IteratorStatement;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FKSetStore
extends AbstractSetStore {
    private final int ownerFieldNumber;
    private String updateFkStmt;
    private String clearNullifyStmt;

    public FKSetStore(AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
        this.setOwner(mmd);
        CollectionMetaData colmd = mmd.getCollection();
        if (colmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056001", (Object)mmd.getFullFieldName()));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType((Class)element_class)) {
            this.elementIsPersistentInterface = storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(element_class.getName());
            if (this.elementIsPersistentInterface) {
                this.emd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForInterface(element_class, clr);
            } else {
                this.emd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
                if (this.emd != null) {
                    // empty if block
                }
            }
        } else {
            this.emd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new NucleusUserException(LOCALISER.msg("056003", (Object)element_class.getName(), (Object)mmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        if (this.elementInfo == null || this.elementInfo.length == 0) {
            throw new NucleusUserException(LOCALISER.msg("056075", (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)this.elementType));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIdMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        if (mmd.getMappedBy() != null) {
            AbstractMemberMetaData eofmd = this.emd.getMetaDataForMember(mmd.getMappedBy());
            if (eofmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056024", (Object)mmd.getFullFieldName(), (Object)mmd.getMappedBy(), (Object)element_class.getName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerFieldNumber = this.emd.getAbsolutePositionOfMember(ownerFieldName);
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getMemberMapping(eofmd);
            if (this.ownerMapping == null && this.elementInfo.length > 1) {
                this.ownerMapping = this.elementInfo[0].getDatastoreClass().getMemberMapping(eofmd.getName());
            }
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056029", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.elementType, (Object)ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new NucleusUserException(LOCALISER.msg("056026", (Object)ownerFieldName, (Object)this.elementType, (Object)eofmd.getTypeName(), (Object)mmd.getClassName()));
            }
        } else {
            this.ownerFieldNumber = -1;
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 5);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056030", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.elementType));
            }
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = mmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = mmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (mmd.getMappedBy() != null && this.ownerMapping.getTable() != this.containerTable) {
            this.containerTable = this.ownerMapping.getTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(ObjectProvider op, Object element, Object owner) {
        boolean retval;
        if (element == null) {
            return false;
        }
        this.validateElementForWriting(op.getExecutionContext(), element, null);
        ExecutionContext ec = op.getExecutionContext();
        String stmt = this.getUpdateFkStmt(element);
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                int jdbcPosition = 1;
                if (this.elementInfo.length > 1) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                    if (table != null) {
                        stmt = stmt.replace("<TABLE NAME>", table.toString());
                    } else {
                        NucleusLogger.PERSISTENCE.warn((Object)("FKSetStore.updateElementFK : need to set table in statement but dont know table where to store " + element));
                    }
                }
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                try {
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, this.ownerMapping), null, op, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, this.ownerMapping), null);
                        }
                    } else if (this.ownerMemberMetaData != null) {
                        this.ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, this.ownerMapping), op.getObject(), op, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                    } else {
                        this.ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, this.ownerMapping), op.getObject());
                    }
                    jdbcPosition += this.ownerMapping.getNumberOfDatastoreMappings();
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, stmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)stmt), (Throwable)e);
        }
        return retval;
    }

    protected int getFieldNumberInElementForBidirectional(ObjectProvider op) {
        if (this.ownerFieldNumber < 0) {
            return -1;
        }
        return op.getClassMetaData().getAbsolutePositionOfMember(this.ownerMemberMetaData.getMappedBy());
    }

    @Override
    public void update(ObjectProvider op, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(op);
            return;
        }
        Iterator elemIter = this.iterator(op);
        HashSet existing = new HashSet();
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(op, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.size() != coll.size()) {
            for (Object elem : coll) {
                if (existing.contains(elem)) continue;
                this.add(op, elem, 0);
            }
        }
    }

    @Override
    public boolean add(ObjectProvider op, Object element, int size) {
        int fieldNumInElement;
        Object elementId;
        DatastoreClass elementTbl;
        boolean inserted;
        AbstractClassMetaData[] managingCmds;
        Class elementTypeCls;
        if (element == null) {
            throw new NucleusUserException(LOCALISER.msg("056039"));
        }
        Object newOwner = op.getObject();
        ExecutionContext ec = op.getExecutionContext();
        boolean isPersistentInterface = this.storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(this.elementType);
        DatastoreClass elementTable = null;
        elementTable = isPersistentInterface ? this.storeMgr.getDatastoreClass(this.storeMgr.getNucleusContext().getMetaDataManager().getImplementationNameForPersistentInterface(this.elementType), this.clr) : ((elementTypeCls = this.clr.classForName(this.elementType)).isInterface() ? this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr) : this.storeMgr.getDatastoreClass(this.elementType, this.clr));
        if (elementTable == null && (managingCmds = this.storeMgr.getClassesManagingTableForClass(this.emd, this.clr)) != null && managingCmds.length > 0) {
            for (int i = 0; i < managingCmds.length; ++i) {
                Class tblCls = this.clr.classForName(managingCmds[i].getFullClassName());
                if (!tblCls.isAssignableFrom(element.getClass())) continue;
                elementTable = this.storeMgr.getDatastoreClass(managingCmds[i].getFullClassName(), this.clr);
                break;
            }
        }
        if (inserted = this.validateElementForWriting(ec, element, new FieldValues(elementTbl = elementTable, op, newOwner, ec){
            final /* synthetic */ DatastoreClass val$elementTbl;
            final /* synthetic */ ObjectProvider val$op;
            final /* synthetic */ Object val$newOwner;
            final /* synthetic */ ExecutionContext val$ec;
            {
                this.val$elementTbl = datastoreClass;
                this.val$op = objectProvider;
                this.val$newOwner = object;
                this.val$ec = executionContext;
            }

            public void fetchFields(ObjectProvider elementOP) {
                int fieldNumInElement;
                if (this.val$elementTbl != null) {
                    JavaTypeMapping externalFKMapping = this.val$elementTbl.getExternalMapping(FKSetStore.this.ownerMemberMetaData, 5);
                    if (externalFKMapping != null) {
                        elementOP.setAssociatedValue((Object)externalFKMapping, this.val$op.getObject());
                    }
                    if (FKSetStore.this.relationDiscriminatorMapping != null) {
                        elementOP.setAssociatedValue((Object)FKSetStore.this.relationDiscriminatorMapping, (Object)FKSetStore.this.relationDiscriminatorValue);
                    }
                }
                if ((fieldNumInElement = FKSetStore.this.getFieldNumberInElementForBidirectional(elementOP)) >= 0) {
                    Object currentOwner = elementOP.provideField(fieldNumInElement);
                    if (currentOwner == null) {
                        NucleusLogger.PERSISTENCE.info((Object)BaseContainerStore.LOCALISER.msg("056037", (Object)this.val$op.getObjectAsPrintable(), (Object)FKSetStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementOP.getObject())));
                        elementOP.replaceFieldMakeDirty(fieldNumInElement, this.val$newOwner);
                    } else if (currentOwner != this.val$newOwner) {
                        Object ownerId1 = this.val$ec.getApiAdapter().getIdForObject(currentOwner);
                        Object ownerId2 = this.val$ec.getApiAdapter().getIdForObject(this.val$newOwner);
                        if (ownerId1 != null && ownerId2 != null && ownerId1.equals(ownerId2)) {
                            if (!elementOP.getExecutionContext().getApiAdapter().isDetached(this.val$newOwner)) {
                                elementOP.replaceField(fieldNumInElement, this.val$newOwner);
                            }
                        } else if (this.val$op.getReferencedPC() == null) {
                            throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056038", (Object)this.val$op.getObjectAsPrintable(), (Object)FKSetStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementOP.getObject()), (Object)StringUtils.toJVMIDString((Object)currentOwner)));
                        }
                    }
                }
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        })) {
            return true;
        }
        ObjectProvider elementOP = ec.findObjectProvider(element);
        if (elementOP == null && (elementId = ec.getApiAdapter().getIdForObject(element)) != null && (element = ec.findObject(elementId, false, false, element.getClass().getName())) != null) {
            elementOP = ec.findObjectProvider(element);
        }
        if ((fieldNumInElement = this.getFieldNumberInElementForBidirectional(elementOP)) >= 0) {
            elementOP.isLoaded(fieldNumInElement);
            Object oldOwner = elementOP.provideField(fieldNumInElement);
            if (oldOwner != newOwner) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("055009", (Object)op.getObjectAsPrintable(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)element)));
                }
                elementOP.replaceFieldMakeDirty(fieldNumInElement, newOwner);
                if (ec.getManageRelations()) {
                    ec.getRelationshipManager(elementOP).relationChange(fieldNumInElement, oldOwner, newOwner);
                }
                if (ec.isFlushing()) {
                    elementOP.flush();
                }
            }
            return oldOwner != newOwner;
        }
        boolean contained = this.contains(op, element);
        return contained ? false : this.updateElementFk(op, element, newOwner);
    }

    @Override
    public boolean addAll(ObjectProvider op, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean success = false;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (!this.add(op, iter.next(), -1)) continue;
            success = true;
        }
        return success;
    }

    @Override
    public boolean remove(ObjectProvider op, Object element, int size, boolean allowDependentField) {
        if (element == null) {
            return false;
        }
        if (!this.validateElementForReading(op, element)) {
            return false;
        }
        Object elementToRemove = element;
        ExecutionContext ec = op.getExecutionContext();
        if (ec.getApiAdapter().isDetached(element)) {
            elementToRemove = ec.findObject(ec.getApiAdapter().getIdForObject(element), true, false, element.getClass().getName());
        }
        ObjectProvider elementOP = ec.findObjectProvider(elementToRemove);
        Object oldOwner = null;
        if (this.ownerFieldNumber >= 0 && !ec.getApiAdapter().isDeleted(elementToRemove)) {
            elementOP.isLoaded(this.ownerFieldNumber);
            oldOwner = elementOP.provideField(this.ownerFieldNumber);
        }
        if (this.ownerFieldNumber >= 0 && oldOwner != op.getObject() && oldOwner != null) {
            return false;
        }
        boolean deleteElement = this.checkRemovalOfElementShouldDelete(op);
        if (deleteElement) {
            if (ec.getApiAdapter().isPersistable(elementToRemove) && ec.getApiAdapter().isDeleted(elementToRemove)) {
                elementOP.flush();
            } else {
                ec.deleteObjectInternal(elementToRemove);
            }
        } else {
            this.manageRemovalOfElement(op, elementToRemove);
            this.updateElementFk(op, elementToRemove, null);
        }
        return true;
    }

    @Override
    public boolean removeAll(ObjectProvider op, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean success = true;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (!this.remove(op, iter.next(), -1, true)) continue;
            success = false;
        }
        return success;
    }

    protected boolean checkRemovalOfElementShouldDelete(ObjectProvider op) {
        boolean delete = false;
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056034"));
            }
            delete = true;
        } else if (this.ownerMapping.isNullable()) {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056036"));
            }
            delete = false;
        } else {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056035"));
            }
            delete = true;
        }
        return delete;
    }

    protected void manageRemovalOfElement(ObjectProvider op, Object element) {
        ObjectProvider elementOP;
        ExecutionContext ec = op.getExecutionContext();
        if (this.relationType == RelationType.ONE_TO_MANY_BI && !ec.getApiAdapter().isDeleted(element) && (elementOP = ec.findObjectProvider(element)) != null) {
            int relatedFieldNumber;
            Object currentValue;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("055010", (Object)op.getObjectAsPrintable(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)element)));
            }
            if ((currentValue = elementOP.provideField(relatedFieldNumber = this.getFieldNumberInElementForBidirectional(elementOP))) != null) {
                elementOP.replaceFieldMakeDirty(relatedFieldNumber, null);
                if (ec.isFlushing()) {
                    elementOP.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(ObjectProvider op) {
        ExecutionContext ec = op.getExecutionContext();
        boolean deleteElements = this.checkRemovalOfElementShouldDelete(op);
        if (deleteElements) {
            Iterator elementsIter = this.iterator(op);
            if (elementsIter != null) {
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    if (ec.getApiAdapter().isPersistable(element) && ec.getApiAdapter().isDeleted(element)) {
                        ec.findObjectProvider(element).flush();
                        continue;
                    }
                    ec.deleteObjectInternal(element);
                }
            }
        } else {
            op.isLoaded(this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Collection value = (Collection)op.provideField(this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Iterator elementsIter = null;
            elementsIter = value != null && !value.isEmpty() ? value.iterator() : this.iterator(op);
            if (elementsIter != null) {
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    this.manageRemovalOfElement(op, element);
                }
            }
            String stmt = this.getClearNullifyStmt();
            try {
                if (this.elementInfo.length > 1) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(this.elementInfo[0].getClassName(), this.clr);
                    if (table != null) {
                        stmt = stmt.replace("<TABLE NAME>", table.toString());
                    } else {
                        NucleusLogger.PERSISTENCE.warn((Object)("FKSetStore.updateElementFK : need to set table in statement but dont know table where to store " + this.elementInfo[0].getClassName()));
                    }
                }
                ManagedConnection mconn = this.storeMgr.getConnection(ec);
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                    try {
                        int jdbcPosition = 1;
                        BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                        sqlControl.executeStatementUpdate(ec, mconn, stmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)stmt), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getClearNullifyStmt() {
        if (this.clearNullifyStmt == null) {
            FKSetStore fKSetStore = this;
            synchronized (fKSetStore) {
                int i;
                StringBuffer stmt = new StringBuffer("UPDATE ");
                if (this.elementInfo.length > 1) {
                    stmt.append("<TABLE NAME>");
                } else {
                    stmt.append(this.containerTable.toString());
                }
                stmt.append(" SET ");
                for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(", ");
                    }
                    stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                    stmt.append("=NULL");
                }
                if (this.relationDiscriminatorMapping != null) {
                    for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(", ");
                        stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                        stmt.append("=NULL");
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                this.clearNullifyStmt = stmt.toString();
            }
        }
        return this.clearNullifyStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUpdateFkStmt(Object element) {
        if (this.elementMapping instanceof ReferenceMapping && this.elementMapping.getNumberOfDatastoreMappings() > 1) {
            return this.getUpdateFkStatementString(element);
        }
        if (this.updateFkStmt == null) {
            FKSetStore fKSetStore = this;
            synchronized (fKSetStore) {
                this.updateFkStmt = this.getUpdateFkStatementString(element);
            }
        }
        return this.updateFkStmt;
    }

    private String getUpdateFkStatementString(Object element) {
        int i;
        StringBuffer stmt = new StringBuffer("UPDATE ");
        if (this.elementInfo.length > 1) {
            stmt.append("<TABLE NAME>");
        } else {
            stmt.append(this.containerTable.toString());
        }
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
            stmt.append("=");
            stmt.append(((AbstractDatastoreMapping)this.ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                stmt.append("=");
                stmt.append(((AbstractDatastoreMapping)this.relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.elementsAreSerialised, null, true);
        return stmt.toString();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Iterator iterator(ObjectProvider op) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IteratorStatement getIteratorStatement(ClassLoaderResolver clr, FetchPlan fp, boolean addRestrictionOnOwner) {
        SQLStatement sqlStmt = null;
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        StatementClassMapping iteratorMappingClass = new StatementClassMapping();
        if (this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            String elementType = this.ownerMemberMetaData.getCollection().getElementType();
            if (ClassUtils.isReferenceType((Class)clr.classForName(elementType))) {
                String[] clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, clr, cls, true, null, null).getStatement();
            } else {
                sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, clr, clr.classForName(this.elementInfo[0].getClassName()), true, null, null).getStatement();
            }
            this.iterateUsingDiscriminator = true;
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, iteratorMappingClass, fp, sqlStmt.getPrimaryTable(), this.emd, 0);
        } else {
            boolean selectFetchPlan = true;
            Class elementTypeCls = clr.classForName(this.elementType);
            if (elementTypeCls.isInterface() && this.elementInfo.length > 1) {
                selectFetchPlan = false;
            }
            for (int i = 0; i < this.elementInfo.length; ++i) {
                Class elementCls = clr.classForName(this.elementInfo[i].getClassName());
                UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, clr, elementCls, true, null, null);
                stmtGen.setOption("selectNucleusType");
                iteratorMappingClass.setNucleusTypeColumnName("NUCLEUS_TYPE");
                SQLStatement subStmt = stmtGen.getStatement();
                if (selectFetchPlan) {
                    if (sqlStmt == null) {
                        SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, iteratorMappingClass, fp, subStmt.getPrimaryTable(), this.elementInfo[i].getAbstractClassMetaData(), 0);
                    } else {
                        SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, null, fp, subStmt.getPrimaryTable(), this.elementInfo[i].getAbstractClassMetaData(), 0);
                    }
                } else if (sqlStmt == null) {
                    SQLStatementHelper.selectIdentityOfCandidateInStatement(subStmt, iteratorMappingClass, this.elementInfo[i].getAbstractClassMetaData());
                } else {
                    SQLStatementHelper.selectIdentityOfCandidateInStatement(subStmt, null, this.elementInfo[i].getAbstractClassMetaData());
                }
                if (sqlStmt == null) {
                    sqlStmt = subStmt;
                    continue;
                }
                sqlStmt.union(subStmt);
            }
        }
        if (addRestrictionOnOwner) {
            SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
            SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
            SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
            sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        }
        if (this.relationDiscriminatorMapping != null) {
            SQLTable distSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.relationDiscriminatorMapping);
            SQLExpression distExpr = exprFactory.newExpression(sqlStmt, distSqlTbl, this.relationDiscriminatorMapping);
            SQLExpression distVal = exprFactory.newLiteral(sqlStmt, this.relationDiscriminatorMapping, this.relationDiscriminatorValue);
            sqlStmt.whereAnd(distExpr.eq(distVal), true);
        }
        if (this.orderMapping != null) {
            SQLTable orderSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
            SQLExpression[] orderExprs = new SQLExpression[this.orderMapping.getNumberOfDatastoreMappings()];
            boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreMappings()];
            orderExprs[0] = exprFactory.newExpression(sqlStmt, orderSqlTbl, this.orderMapping);
            sqlStmt.setOrdering(orderExprs, descendingOrder);
        }
        return new IteratorStatement(this, sqlStmt, iteratorMappingClass);
    }
}

