/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import javax.annotation.Nullable;

@GwtCompatible
public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, @Nullable Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static int checkElementIndex(int index2, int size2) {
        return Preconditions.checkElementIndex(index2, size2, "index");
    }

    public static int checkElementIndex(int index2, int size2, @Nullable String desc) {
        if (index2 < 0 || index2 >= size2) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(index2, size2, desc));
        }
        return index2;
    }

    private static String badElementIndex(int index2, int size2, String desc) {
        if (index2 < 0) {
            return Preconditions.format("%s (%s) must not be negative", desc, index2);
        }
        if (size2 < 0) {
            throw new IllegalArgumentException("negative size: " + size2);
        }
        return Preconditions.format("%s (%s) must be less than size (%s)", desc, index2, size2);
    }

    public static int checkPositionIndex(int index2, int size2) {
        return Preconditions.checkPositionIndex(index2, size2, "index");
    }

    public static int checkPositionIndex(int index2, int size2, @Nullable String desc) {
        if (index2 < 0 || index2 > size2) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(index2, size2, desc));
        }
        return index2;
    }

    private static String badPositionIndex(int index2, int size2, String desc) {
        if (index2 < 0) {
            return Preconditions.format("%s (%s) must not be negative", desc, index2);
        }
        if (size2 < 0) {
            throw new IllegalArgumentException("negative size: " + size2);
        }
        return Preconditions.format("%s (%s) must not be greater than size (%s)", desc, index2, size2);
    }

    public static void checkPositionIndexes(int start, int end, int size2) {
        if (start < 0 || end < start || end > size2) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(start, end, size2));
        }
    }

    private static String badPositionIndexes(int start, int end, int size2) {
        if (start < 0 || start > size2) {
            return Preconditions.badPositionIndex(start, size2, "start index");
        }
        if (end < 0 || end > size2) {
            return Preconditions.badPositionIndex(end, size2, "end index");
        }
        return Preconditions.format("end index (%s) must not be less than start index (%s)", end, start);
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

