/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.api;

import java.nio.ByteBuffer;
import kafka.shaded.api.ApiUtils$;
import kafka.shaded.api.PartitionMetadata;
import kafka.shaded.cluster.Broker;
import kafka.shaded.common.ErrorMapping$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class PartitionMetadata$
implements Serializable {
    public static final PartitionMetadata$ MODULE$;

    static {
        new PartitionMetadata$();
    }

    public PartitionMetadata readFrom(ByteBuffer buffer, Map<Object, Broker> brokers) {
        short errorCode = ApiUtils$.MODULE$.readShortInRange(buffer, "error code", new Tuple2<Object, Object>(BoxesRunTime.boxToShort((short)-1), BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
        int partitionId = ApiUtils$.MODULE$.readIntInRange(buffer, "partition id", new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        int leaderId = buffer.getInt();
        Option<Broker> leader = brokers.get(BoxesRunTime.boxToInteger(leaderId));
        int numReplicas = ApiUtils$.MODULE$.readIntInRange(buffer, "number of all replicas", new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        IndexedSeq<Object> replicaIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numReplicas).map(new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$2;

            public final int apply(int x$2) {
                return this.apply$mcII$sp(x$2);
            }

            public int apply$mcII$sp(int x$2) {
                return this.buffer$2.getInt();
            }
            {
                this.buffer$2 = buffer$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq<Broker> replicas = replicaIds.map(brokers, IndexedSeq$.MODULE$.canBuildFrom());
        int numIsr = ApiUtils$.MODULE$.readIntInRange(buffer, "number of in-sync replicas", new Tuple2$mcII$sp(0, Integer.MAX_VALUE));
        IndexedSeq<Object> isrIds = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numIsr).map(new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$2;

            public final int apply(int x$3) {
                return this.apply$mcII$sp(x$3);
            }

            public int apply$mcII$sp(int x$3) {
                return this.buffer$2.getInt();
            }
            {
                this.buffer$2 = buffer$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq<Broker> isr = isrIds.map(brokers, IndexedSeq$.MODULE$.canBuildFrom());
        return new PartitionMetadata(partitionId, leader, replicas, isr, errorCode);
    }

    public PartitionMetadata apply(int partitionId, Option<Broker> leader, Seq<Broker> replicas, Seq<Broker> isr, short errorCode) {
        return new PartitionMetadata(partitionId, leader, replicas, isr, errorCode);
    }

    public Option<Tuple5<Object, Option<Broker>, Seq<Broker>, Seq<Broker>, Object>> unapply(PartitionMetadata x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple5<Integer, Option<Broker>, Seq<Broker>, Seq<Broker>, Short>>(new Tuple5<Integer, Option<Broker>, Seq<Broker>, Seq<Broker>, Short>(BoxesRunTime.boxToInteger(x$0.partitionId()), x$0.leader(), x$0.replicas(), x$0.isr(), BoxesRunTime.boxToShort(x$0.errorCode())));
    }

    public Seq<Broker> $lessinit$greater$default$4() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public short $lessinit$greater$default$5() {
        return ErrorMapping$.MODULE$.NoError();
    }

    public Seq<Broker> apply$default$4() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public short apply$default$5() {
        return ErrorMapping$.MODULE$.NoError();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PartitionMetadata$() {
        MODULE$ = this;
    }
}

