/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.shaded.framework.imps;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.shaded.RetryLoop;
import org.apache.curator.shaded.drivers.OperationTrace;
import org.apache.curator.shaded.framework.api.BackgroundCallback;
import org.apache.curator.shaded.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.shaded.framework.api.CuratorEventType;
import org.apache.curator.shaded.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.shaded.framework.api.PathAndBytesable;
import org.apache.curator.shaded.framework.api.SetDataBackgroundVersionable;
import org.apache.curator.shaded.framework.api.SetDataBuilder;
import org.apache.curator.shaded.framework.api.UnhandledErrorListener;
import org.apache.curator.shaded.framework.api.VersionPathAndBytesable;
import org.apache.curator.shaded.framework.api.transaction.OperationType;
import org.apache.curator.shaded.framework.api.transaction.TransactionSetDataBuilder;
import org.apache.curator.shaded.framework.imps.BackgroundOperation;
import org.apache.curator.shaded.framework.imps.Backgrounding;
import org.apache.curator.shaded.framework.imps.CuratorEventImpl;
import org.apache.curator.shaded.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.shaded.framework.imps.CuratorMultiTransactionRecord;
import org.apache.curator.shaded.framework.imps.OperationAndData;
import org.apache.curator.shaded.framework.imps.PathAndBytes;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.data.Stat;

public class SetDataBuilderImpl
implements SetDataBuilder,
BackgroundOperation<PathAndBytes>,
ErrorListenerPathAndBytesable<Stat> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private int version;
    private boolean compress;

    SetDataBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.version = -1;
        this.compress = false;
    }

    public SetDataBuilderImpl(CuratorFrameworkImpl client, Backgrounding backgrounding, int version, boolean compress) {
        this.client = client;
        this.backgrounding = backgrounding;
        this.version = version;
        this.compress = compress;
    }

    <T> TransactionSetDataBuilder<T> asTransactionSetDataBuilder(final T context, final CuratorMultiTransactionRecord transaction) {
        return new TransactionSetDataBuilder<T>(){

            @Override
            public T forPath(String path, byte[] data2) throws Exception {
                if (SetDataBuilderImpl.this.compress) {
                    data2 = SetDataBuilderImpl.this.client.getCompressionProvider().compress(path, data2);
                }
                String fixedPath = SetDataBuilderImpl.this.client.fixForNamespace(path);
                transaction.add(Op.setData(fixedPath, data2, SetDataBuilderImpl.this.version), OperationType.SET_DATA, path);
                return context;
            }

            @Override
            public T forPath(String path) throws Exception {
                return this.forPath(path, SetDataBuilderImpl.this.client.getDefaultData());
            }

            @Override
            public PathAndBytesable<T> withVersion(int version) {
                SetDataBuilderImpl.this.withVersion(version);
                return this;
            }

            @Override
            public VersionPathAndBytesable<T> compressed() {
                SetDataBuilderImpl.this.compress = true;
                return this;
            }
        };
    }

    @Override
    public SetDataBackgroundVersionable compressed() {
        this.compress = true;
        return new SetDataBackgroundVersionable(){

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground() {
                return SetDataBuilderImpl.this.inBackground();
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context) {
                return SetDataBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return SetDataBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(Object context) {
                return SetDataBuilderImpl.this.inBackground(context);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback) {
                return SetDataBuilderImpl.this.inBackground(callback);
            }

            @Override
            public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
                return SetDataBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public Stat forPath(String path, byte[] data2) throws Exception {
                return SetDataBuilderImpl.this.forPath(path, data2);
            }

            @Override
            public Stat forPath(String path) throws Exception {
                return SetDataBuilderImpl.this.forPath(path);
            }

            @Override
            public BackgroundPathAndBytesable<Stat> withVersion(int version) {
                return SetDataBuilderImpl.this.withVersion(version);
            }
        };
    }

    @Override
    public BackgroundPathAndBytesable<Stat> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public ErrorListenerPathAndBytesable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("SetDataBuilderImpl-Background");
            final byte[] data2 = operationAndData.getData().getData();
            this.client.getZooKeeper().setData(operationAndData.getData().getPath(), data2, this.version, new AsyncCallback.StatCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    trace.setReturnCode(rc).setRequestBytesLength(data2).setPath(path).setStat(stat).commit();
                    CuratorEventImpl event = new CuratorEventImpl(SetDataBuilderImpl.this.client, CuratorEventType.SET_DATA, rc, path, null, ctx, stat, null, null, null, null, null);
                    SetDataBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            }, this.backgrounding.getContext());
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, null);
        }
    }

    @Override
    public Stat forPath(String path) throws Exception {
        return this.forPath(path, this.client.getDefaultData());
    }

    @Override
    public Stat forPath(String path, byte[] data2) throws Exception {
        this.client.getSchemaSet().getSchema(path).validateGeneral(path, data2, null);
        if (this.compress) {
            data2 = this.client.getCompressionProvider().compress(path, data2);
        }
        path = this.client.fixForNamespace(path);
        Stat resultStat = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<PathAndBytes>(this, new PathAndBytes(path, data2), this.backgrounding.getCallback(), null, this.backgrounding.getContext(), null), null);
        } else {
            resultStat = this.pathInForeground(path, data2);
        }
        return resultStat;
    }

    int getVersion() {
        return this.version;
    }

    private Stat pathInForeground(final String path, final byte[] data2) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("SetDataBuilderImpl-Foreground");
        Stat resultStat = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                return SetDataBuilderImpl.this.client.getZooKeeper().setData(path, data2, SetDataBuilderImpl.this.version);
            }
        });
        trace.setRequestBytesLength(data2).setPath(path).setStat(resultStat).commit();
        return resultStat;
    }
}

