/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.shaded.retry;

import org.apache.curator.shaded.retry.ExponentialBackoffRetry;
import org.apache.curator.shaded.shaded.com.google.common.annotations.VisibleForTesting;

public class BoundedExponentialBackoffRetry
extends ExponentialBackoffRetry {
    private final int maxSleepTimeMs;

    public BoundedExponentialBackoffRetry(int baseSleepTimeMs, int maxSleepTimeMs, int maxRetries) {
        super(baseSleepTimeMs, maxRetries);
        this.maxSleepTimeMs = maxSleepTimeMs;
    }

    @VisibleForTesting
    public int getMaxSleepTimeMs() {
        return this.maxSleepTimeMs;
    }

    @Override
    protected long getSleepTimeMs(int retryCount, long elapsedTimeMs) {
        return Math.min((long)this.maxSleepTimeMs, super.getSleepTimeMs(retryCount, elapsedTimeMs));
    }
}

