/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.clients.producer.internals;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.shaded.clients.producer.Partitioner;
import org.apache.kafka.shaded.common.Cluster;
import org.apache.kafka.shaded.common.PartitionInfo;
import org.apache.kafka.shaded.common.utils.Utils;

public class DefaultPartitioner
implements Partitioner {
    private final AtomicInteger counter = new AtomicInteger(new Random().nextInt());

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public int partition(String topic, Object key, byte[] keyBytes, Object value2, byte[] valueBytes, Cluster cluster) {
        List<PartitionInfo> partitions = cluster.partitionsForTopic(topic);
        int numPartitions = partitions.size();
        if (keyBytes == null) {
            int nextValue = this.counter.getAndIncrement();
            List<PartitionInfo> availablePartitions = cluster.availablePartitionsForTopic(topic);
            if (availablePartitions.size() > 0) {
                int part = Utils.toPositive(nextValue) % availablePartitions.size();
                return availablePartitions.get(part).partition();
            }
            return Utils.toPositive(nextValue) % numPartitions;
        }
        return Utils.toPositive(Utils.murmur2(keyBytes)) % numPartitions;
    }

    @Override
    public void close() {
    }
}

