/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.common.security.authenticator;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import org.apache.kafka.shaded.common.security.auth.Login;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogin
implements Login {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogin.class);
    private String loginContextName;
    private LoginContext loginContext;

    @Override
    public void configure(Map<String, ?> configs, String loginContextName) {
        this.loginContextName = loginContextName;
    }

    @Override
    public LoginContext login() throws LoginException {
        AppConfigurationEntry[] configEntries;
        String jaasConfigFile = System.getProperty("java.security.auth.login.config");
        if (jaasConfigFile == null) {
            log.debug("System property 'java.security.auth.login.config' is not set, using default JAAS configuration.");
        }
        if ((configEntries = Configuration.getConfiguration().getAppConfigurationEntry(this.loginContextName)) == null) {
            String errorMessage = "Could not find a '" + this.loginContextName + "' entry in the JAAS configuration. System property '" + "java.security.auth.login.config" + "' is " + (jaasConfigFile == null ? "not set" : jaasConfigFile);
            throw new IllegalArgumentException(errorMessage);
        }
        this.loginContext = new LoginContext(this.loginContextName, new LoginCallbackHandler());
        this.loginContext.login();
        log.info("Successfully logged in.");
        return this.loginContext;
    }

    @Override
    public Subject subject() {
        return this.loginContext.getSubject();
    }

    public static class LoginCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(nc.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    String errorMessage = "Could not login: the client is being asked for a password, but the Kafka client code does not currently support obtaining a password from the user.";
                    throw new UnsupportedCallbackException(callback, errorMessage);
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL Login callback");
            }
        }
    }
}

