/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.client.HostProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public final class StaticHostProvider
implements HostProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StaticHostProvider.class);
    private final List<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>(5);
    private int lastIndex = -1;
    private int currentIndex = -1;
    private Resolver resolver;

    public StaticHostProvider(Collection<InetSocketAddress> serverAddresses) {
        this.resolver = new Resolver(){

            @Override
            public InetAddress[] getAllByName(String name) throws UnknownHostException {
                return InetAddress.getAllByName(name);
            }
        };
        this.init(serverAddresses);
    }

    public StaticHostProvider(Collection<InetSocketAddress> serverAddresses, Resolver resolver) {
        this.resolver = resolver;
        this.init(serverAddresses);
    }

    private void init(Collection<InetSocketAddress> serverAddresses) {
        if (serverAddresses.isEmpty()) {
            throw new IllegalArgumentException("A HostProvider may not be empty!");
        }
        this.serverAddresses.addAll(serverAddresses);
        Collections.shuffle(this.serverAddresses);
    }

    private String getHostString(InetSocketAddress addr) {
        String hostString = "";
        if (addr == null) {
            return hostString;
        }
        if (!addr.isUnresolved()) {
            InetAddress ia = addr.getAddress();
            hostString = ia.toString().startsWith("/") ? ia.getHostAddress() : addr.getHostName();
        } else {
            String addrString = addr.toString();
            hostString = addrString.substring(0, addrString.lastIndexOf(58));
        }
        return hostString;
    }

    @Override
    public int size() {
        return this.serverAddresses.size();
    }

    @Override
    public InetSocketAddress next(long spinDelay) {
        ++this.currentIndex;
        this.currentIndex %= this.serverAddresses.size();
        if (this.currentIndex == this.lastIndex && spinDelay > 0L) {
            try {
                Thread.sleep(spinDelay);
            }
            catch (InterruptedException e) {
                LOG.warn("Unexpected exception", e);
            }
        } else if (this.lastIndex == -1) {
            this.lastIndex = 0;
        }
        InetSocketAddress curAddr = this.serverAddresses.get(this.currentIndex);
        try {
            String curHostString = this.getHostString(curAddr);
            ArrayList<InetAddress> resolvedAddresses = new ArrayList<InetAddress>(Arrays.asList(this.resolver.getAllByName(curHostString)));
            if (resolvedAddresses.isEmpty()) {
                return curAddr;
            }
            Collections.shuffle(resolvedAddresses);
            return new InetSocketAddress((InetAddress)resolvedAddresses.get(0), curAddr.getPort());
        }
        catch (UnknownHostException e) {
            return curAddr;
        }
    }

    @Override
    public void onConnected() {
        this.lastIndex = this.currentIndex;
    }

    public static interface Resolver {
        public InetAddress[] getAllByName(String var1) throws UnknownHostException;
    }
}

