/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.multipart;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.multipart.Attribute;
import org.jboss.netty.handler.codec.http.multipart.InterfaceHttpData;
import org.jboss.netty.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalAttribute
implements InterfaceHttpData {
    protected final List<String> value = new ArrayList<String>();
    private final Charset charset;

    @Deprecated
    public InternalAttribute() {
        this(CharsetUtil.UTF_8);
    }

    public InternalAttribute(Charset charset) {
        this.charset = charset;
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.InternalAttribute;
    }

    @Deprecated
    public List<String> getValue() {
        return this.value;
    }

    public void addValue(String value2) {
        if (value2 == null) {
            throw new NullPointerException("value");
        }
        this.value.add(value2);
    }

    public void addValue(String value2, int rank) {
        if (value2 == null) {
            throw new NullPointerException("value");
        }
        this.value.add(rank, value2);
    }

    public void setValue(String value2, int rank) {
        if (value2 == null) {
            throw new NullPointerException("value");
        }
        this.value.set(rank, value2);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return this.getName().equalsIgnoreCase(attribute.getName());
    }

    @Override
    public int compareTo(InterfaceHttpData o) {
        if (!(o instanceof InternalAttribute)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)o.getHttpDataType()));
        }
        return this.compareTo((InternalAttribute)o);
    }

    @Override
    public int compareTo(InternalAttribute o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public int size() {
        int size2 = 0;
        for (String elt : this.value) {
            try {
                size2 += elt.getBytes(this.charset.name()).length;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return size2;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        for (String elt : this.value) {
            result2.append(elt);
        }
        return result2.toString();
    }

    public ChannelBuffer toChannelBuffer() {
        ChannelBuffer[] buffers = new ChannelBuffer[this.value.size()];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = ChannelBuffers.copiedBuffer((CharSequence)this.value.get(i), this.charset);
        }
        return ChannelBuffers.wrappedBuffer(buffers);
    }

    @Override
    public String getName() {
        return "InternalAttribute";
    }
}

