/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.websocketx;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class WebSocket00FrameEncoder
extends OneToOneEncoder {
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                ChannelBuffer data2 = frame.getBinaryData();
                ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data2.order(), data2.readableBytes() + 2);
                encoded.writeByte(0);
                encoded.writeBytes(data2, data2.readerIndex(), data2.readableBytes());
                encoded.writeByte(-1);
                return encoded;
            }
            if (frame instanceof CloseWebSocketFrame) {
                ChannelBuffer data3 = frame.getBinaryData();
                ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data3.order(), 2);
                encoded.writeByte(-1);
                encoded.writeByte(0);
                return encoded;
            }
            ChannelBuffer data4 = frame.getBinaryData();
            int dataLen = data4.readableBytes();
            ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data4.order(), dataLen + 5);
            encoded.writeByte(-128);
            int b1 = dataLen >>> 28 & 0x7F;
            int b2 = dataLen >>> 14 & 0x7F;
            int b3 = dataLen >>> 7 & 0x7F;
            int b4 = dataLen & 0x7F;
            if (b1 == 0) {
                if (b2 == 0) {
                    if (b3 == 0) {
                        encoded.writeByte(b4);
                    } else {
                        encoded.writeByte(b3 | 0x80);
                        encoded.writeByte(b4);
                    }
                } else {
                    encoded.writeByte(b2 | 0x80);
                    encoded.writeByte(b3 | 0x80);
                    encoded.writeByte(b4);
                }
            } else {
                encoded.writeByte(b1 | 0x80);
                encoded.writeByte(b2 | 0x80);
                encoded.writeByte(b3 | 0x80);
                encoded.writeByte(b4);
            }
            encoded.writeBytes(data4, data4.readerIndex(), dataLen);
            return encoded;
        }
        return msg;
    }
}

