/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.websocketx;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketUtil;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public class WebSocketServerHandshaker00
extends WebSocketServerHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker00.class);

    public WebSocketServerHandshaker00(String webSocketURL, String subprotocols) {
        this(webSocketURL, subprotocols, Long.MAX_VALUE);
    }

    public WebSocketServerHandshaker00(String webSocketURL, String subprotocols, long maxFramePayloadLength) {
        super(WebSocketVersion.V00, webSocketURL, subprotocols, maxFramePayloadLength);
    }

    public ChannelFuture handshake(Channel channel, HttpRequest req) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Channel %s WS Version 00 server handshake", channel.getId()));
        }
        if (!"Upgrade".equalsIgnoreCase(req.headers().get("Connection")) || !"WebSocket".equalsIgnoreCase(req.headers().get("Upgrade"))) {
            throw new WebSocketHandshakeException("not a WebSocket handshake request: missing upgrade");
        }
        boolean isHixie76 = req.headers().contains("Sec-WebSocket-Key1") && req.headers().contains("Sec-WebSocket-Key2");
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, isHixie76 ? "WebSocket Protocol Handshake" : "Web Socket Protocol Handshake"));
        res.headers().add("Upgrade", "WebSocket");
        res.headers().add("Connection", "Upgrade");
        if (isHixie76) {
            res.headers().add("Sec-WebSocket-Origin", req.headers().get("Origin"));
            res.headers().add("Sec-WebSocket-Location", this.getWebSocketUrl());
            String subprotocols = req.headers().get("Sec-WebSocket-Protocol");
            if (subprotocols != null) {
                String selectedSubprotocol = this.selectSubprotocol(subprotocols);
                if (selectedSubprotocol == null) {
                    throw new WebSocketHandshakeException("Requested subprotocol(s) not supported: " + subprotocols);
                }
                res.headers().add("Sec-WebSocket-Protocol", selectedSubprotocol);
                this.setSelectedSubprotocol(selectedSubprotocol);
            }
            String key1 = req.headers().get("Sec-WebSocket-Key1");
            String key2 = req.headers().get("Sec-WebSocket-Key2");
            int a = (int)(Long.parseLong(key1.replaceAll("[^0-9]", "")) / (long)key1.replaceAll("[^ ]", "").length());
            int b = (int)(Long.parseLong(key2.replaceAll("[^0-9]", "")) / (long)key2.replaceAll("[^ ]", "").length());
            long c = req.getContent().readLong();
            ChannelBuffer input2 = ChannelBuffers.buffer(16);
            input2.writeInt(a);
            input2.writeInt(b);
            input2.writeLong(c);
            res.setContent(WebSocketUtil.md5(input2));
        } else {
            res.headers().add("WebSocket-Origin", req.headers().get("Origin"));
            res.headers().add("WebSocket-Location", this.getWebSocketUrl());
            String protocol = req.headers().get("WebSocket-Protocol");
            if (protocol != null) {
                res.headers().add("WebSocket-Protocol", this.selectSubprotocol(protocol));
            }
        }
        return this.writeHandshakeResponse(channel, res, new WebSocket00FrameEncoder(), new WebSocket00FrameDecoder(this.getMaxFramePayloadLength()));
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        return channel.write(frame);
    }
}

