/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.cpp;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Join;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.Constructor;
import com.google.gxp.compiler.base.Interface;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.cpp.BaseCppCodeGenerator;
import com.google.gxp.compiler.msgextract.MessageExtractedTree;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CppHeaderCodeGenerator
extends BaseCppCodeGenerator<MessageExtractedTree> {
    private final ImmutableSet<TemplateName> extraIncludess;

    public CppHeaderCodeGenerator(MessageExtractedTree tree, Set<Callable> requirements) {
        super(tree);
        this.extraIncludess = ImmutableSet.copyOf(Iterables.transform(requirements, new Function<Callable, TemplateName>(){

            @Override
            public TemplateName apply(Callable requirement) {
                return requirement.getName();
            }
        }));
    }

    @Override
    protected InterfaceWorker createInterfaceWorker(Appendable out, AlertSink alertSink, Interface iface) {
        return new InterfaceWorker(out, alertSink, iface, this.extraIncludess);
    }

    @Override
    protected TemplateWorker createTemplateWorker(Appendable out, AlertSink alertSink, Template template) {
        return new TemplateWorker(out, alertSink, template, this.extraIncludess);
    }

    private static class TemplateWorker
    extends BaseCppCodeGenerator.TemplateWorker {
        private final ImmutableSet<TemplateName> extraIncludess;

        public TemplateWorker(Appendable out, AlertSink alertSink, Template template, Set<TemplateName> extraIncludess) {
            super(out, alertSink, template);
            this.extraIncludess = ImmutableSet.copyOf(extraIncludess);
        }

        @Override
        protected void appendClass() {
            SourcePosition pos = this.template.getSourcePosition();
            TemplateName.FullyQualified templateName = this.template.getName();
            this.appendIfdefGuardStart(this.template);
            this.appendLine();
            this.appendLine("#include \"gxp/base/base.h\"");
            this.appendImports(this.template, this.extraIncludess);
            this.appendLine();
            this.appendNamespacesOpen(templateName);
            this.formatLine(pos, "class %s : public GxpTemplate {", this.getClassName(templateName));
            this.appendLine("public:");
            this.appendLine(pos, this.getWriteMethodSignature(false, true) + ";");
            this.appendLine();
            this.appendLine(pos, this.getGetGxpClosureMethodSignature(false, true) + ";");
            this.appendLine();
            this.appendExtraWriteMethods(true);
            this.appendLine();
            this.appendInterface();
            this.appendLine();
            this.appendInstance();
            this.appendLine("};");
            this.appendNamespacesClose(templateName);
            this.appendLine();
            this.appendIfdefGuardEnd(this.template);
        }

        protected void appendExtraWriteMethods(boolean isStatic) {
            SourcePosition pos = this.template.getSourcePosition();
            List<Parameter> params = isStatic ? this.template.getAllParameters() : this.template.getParameters();
            for (BaseCppCodeGenerator.Worker.ExtraOutType extraOutType : this.extraOutTypes) {
                this.appendLine(pos, this.getWriteMethodSignature(extraOutType.getOutType(), false, isStatic) + " {");
                this.formatLine(pos, "%s gxp_wrapper(%s);", extraOutType.getOutWrapper(), "gxp_out");
                StringBuilder sb = new StringBuilder("Write(");
                Join.join(sb, ", ", Iterables.concat(Collections.singleton("&gxp_wrapper, gxp_context"), Iterables.transform(params, this.paramToCallName)));
                sb.append(");");
                this.appendLine(pos, sb);
                this.appendLine("}");
            }
        }

        protected void appendInterface() {
            SourcePosition pos = this.template.getSourcePosition();
            this.appendLine("//");
            this.appendLine("// Interface that defines a strategy for writing this GXP");
            this.appendLine("//");
            this.appendCppFormalTypeParameters(true, this.template.getFormalTypeParameters());
            this.appendLine("class Interface {");
            this.appendLine("public:");
            this.appendLine(pos, "virtual ~Interface() {}");
            this.appendLine(pos, "virtual " + this.getWriteMethodSignature(false, false) + " = 0;");
            this.appendLine(pos, "virtual " + this.getGetGxpClosureMethodSignature(false, false) + " = 0;");
            this.appendLine();
            this.appendExtraWriteMethods(false);
            this.appendLine("};");
        }

        protected void appendInstance() {
            Constructor constructor = this.template.getConstructor();
            List<Parameter> cParams = constructor.getParameters();
            SourcePosition pos = constructor.getSourcePosition();
            this.appendLine("//");
            this.appendLine("// Instantiable instance of this GXP");
            this.appendLine("//");
            this.appendCppFormalTypeParameters(true, this.template.getFormalTypeParameters());
            StringBuilder sb = new StringBuilder("class Instance : public Interface");
            this.appendCppFormalTypeParameters(sb, false, this.template.getFormalTypeParameters());
            sb.append(" {");
            this.appendLine(pos, sb);
            this.appendLine("public:");
            sb = new StringBuilder("Instance(");
            Join.join(sb, ", ", Iterables.transform(cParams, this.parameterToCallName));
            sb.append(")");
            if (!cParams.isEmpty()) {
                sb.append("\n  : ");
                Join.join(sb, ", ", Iterables.transform(cParams, this.parameterToInitializer));
            }
            sb.append(" {");
            this.appendLine(sb);
            this.appendLine("}");
            this.appendLine();
            this.appendLine(this.getWriteMethodSignature(false, false) + " {");
            sb = new StringBuilder(this.getClassName(this.template.getName()));
            sb.append("::Write(");
            Join.join(sb, ", ", Iterables.concat(Collections.singleton("gxp_out, gxp_context"), Iterables.transform(this.template.getAllParameters(), this.paramToCallName)));
            sb.append(");");
            this.appendLine(pos, sb);
            this.appendLine("}");
            this.appendLine();
            this.appendLine(null, this.getGetGxpClosureMethodSignature(false, false) + " {");
            sb = new StringBuilder("return ");
            sb.append(this.getClassName(this.template.getName()));
            sb.append("::GetGxpClosure(");
            Join.join(sb, ", ", Iterables.transform(this.template.getAllParameters(), this.paramToCallName));
            sb.append(");");
            this.appendLine(pos, sb);
            this.appendLine("}");
            if (!cParams.isEmpty()) {
                this.appendLine("private:");
                for (Parameter param : cParams) {
                    this.formatLine(param.getSourcePosition(), "%s %s;", this.toCppType(param.getType()), param.getPrimaryName());
                }
            }
            this.appendLine("};");
        }
    }

    private static class InterfaceWorker
    extends BaseCppCodeGenerator.InterfaceWorker {
        private final ImmutableSet<TemplateName> extraIncludess;

        public InterfaceWorker(Appendable out, AlertSink alertSink, Interface iface, Set<TemplateName> extraIncludess) {
            super(out, alertSink, iface);
            this.extraIncludess = ImmutableSet.copyOf(extraIncludess);
        }

        @Override
        protected void appendClass() {
            TemplateName.FullyQualified ifaceName = this.iface.getName();
            this.appendIfdefGuardStart(this.iface);
            this.appendLine();
            this.appendLine("#include \"gxp/base/base.h\"");
            this.appendImports(this.iface, this.extraIncludess);
            this.appendLine();
            this.appendNamespacesOpen(ifaceName);
            this.formatLine(this.iface.getSourcePosition(), "class %s {", this.getClassName(ifaceName));
            this.appendLine("public:");
            this.appendLine("};");
            this.appendNamespacesClose(ifaceName);
            this.appendLine();
            this.appendIfdefGuardEnd(this.iface);
        }
    }
}

