/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.ogn;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.oval.exception.ObjectGraphNavigatorNotAvailableException;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.ReflectionUtils;
import net.sf.oval.ogn.ObjectGraphNavigator;
import net.sf.oval.ogn.ObjectGraphNavigatorDefaultImpl;
import net.sf.oval.ogn.ObjectGraphNavigatorJXPathImpl;

public class ObjectGraphNavigatorRegistry {
    private static final Log LOG = Log.getLog(ObjectGraphNavigatorRegistry.class);
    private final Map<String, ObjectGraphNavigator> cache = new ConcurrentHashMap<String, ObjectGraphNavigator>(2);

    private ObjectGraphNavigator _initializeDefaultOGN(String id) {
        if ("jxpath".equals(id) && ReflectionUtils.isClassPresent("org.apache.commons.jxpath.JXPathContext")) {
            return this.registerObjectGraphNavigator("jxpath", new ObjectGraphNavigatorJXPathImpl());
        }
        if ("".equals(id)) {
            return this.registerObjectGraphNavigator("", new ObjectGraphNavigatorDefaultImpl());
        }
        return null;
    }

    public ObjectGraphNavigator getObjectGraphNavigator(String id) {
        Assert.argumentNotNull("id", id);
        ObjectGraphNavigator ogn = this.cache.get(id);
        if (ogn == null) {
            ogn = this._initializeDefaultOGN(id);
        }
        if (ogn == null) {
            throw new ObjectGraphNavigatorNotAvailableException(id);
        }
        return ogn;
    }

    public ObjectGraphNavigator registerObjectGraphNavigator(String id, ObjectGraphNavigator ogn) throws IllegalArgumentException {
        Assert.argumentNotNull("id", id);
        Assert.argumentNotNull("ogn", ogn);
        LOG.info("Object Graph Navigator '{1}' registered: {2}", (Object)id, ogn);
        this.cache.put(id, ogn);
        return ogn;
    }
}

