/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.io;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.io.Closeables;
import com.google.gxp.com.google.common.io.Files;
import com.google.gxp.com.google.common.io.IoSupplier;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipFiles {
    private ZipFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unzipFile(File zipFile, File targetDirectory) throws IOException {
        Preconditions.checkArgument(targetDirectory.isDirectory(), "%s is not a valid directory", targetDirectory.getAbsolutePath());
        final ZipFile zipFileObj = new ZipFile(zipFile);
        try {
            Enumeration<? extends ZipEntry> entries = zipFileObj.entries();
            while (entries.hasMoreElements()) {
                final ZipEntry entry = entries.nextElement();
                File targetFile = new File(targetDirectory, entry.getName());
                if (entry.isDirectory()) {
                    if (targetFile.mkdir()) continue;
                    throw new IOException("Failed to create directory");
                }
                Files.copy((IoSupplier<? extends InputStream>)new IoSupplier<InputStream>(){

                    @Override
                    public InputStream get() throws IOException {
                        return zipFileObj.getInputStream(entry);
                    }
                }, targetFile);
            }
        }
        finally {
            zipFileObj.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void zipDirectory(File sourceDirectory, File zipFile) throws IOException {
        Preconditions.checkArgument(sourceDirectory.isDirectory(), "%s is not a valid directory", sourceDirectory.getAbsolutePath());
        Preconditions.checkArgument(!zipFile.exists(), "%s does already exist, files are not being overwritten", zipFile.getAbsolutePath());
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
        boolean threw = true;
        try {
            for (File file : sourceDirectory.listFiles()) {
                ZipFiles.zipDirectoryInternal(file, "", zos);
            }
            threw = false;
        }
        finally {
            Closeables.close(zos, threw);
        }
    }

    private static void zipDirectoryInternal(File inputFile, String directoryName, ZipOutputStream zos) throws IOException {
        String entryName = "".equals(directoryName) ? inputFile.getName() : directoryName + "/" + inputFile.getName();
        if (inputFile.isDirectory()) {
            ZipEntry entry = new ZipEntry(entryName + "/");
            zos.putNextEntry(entry);
            for (File file : inputFile.listFiles()) {
                ZipFiles.zipDirectoryInternal(file, entryName, zos);
            }
        } else {
            ZipEntry entry = new ZipEntry(entryName);
            zos.putNextEntry(entry);
            Files.copy(inputFile, zos);
        }
    }
}

