/*
 * Decompiled with CFR 0.152.
 */
package com.google.transconsole.common.messages;

import com.google.gxp.com.google.common.base.Objects;
import com.google.transconsole.common.messages.BaseMessage;
import com.google.transconsole.common.messages.BundleFormat;
import com.google.transconsole.common.messages.MessageFragment;
import java.util.List;

public final class Translation
extends BaseMessage {
    private final String language;

    Translation(String id, String language, List<MessageFragment> fragments) {
        super(id, fragments);
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public String toXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<translation");
        this.appendAttribute(sb, "id", this.getId());
        sb.append(">");
        sb.append(this.getFragmentsAsXml());
        sb.append("</translation>");
        return sb.toString();
    }

    @Override
    protected String getFragmentsAsXml() {
        StringBuilder sb = new StringBuilder();
        for (MessageFragment f : this.fragments) {
            sb.append(f.toXml(BundleFormat.XTB));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<Translation [id: ").append(this.id).append(", language: ").append(this.language).append(", content: ").append(this.fragments).append("]>");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Translation) {
            Translation t = (Translation)other;
            return Objects.equal(this.id, t.id) && Objects.equal(this.fragments, t.fragments) && Objects.equal(t.language, this.language);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.fragments, this.language);
    }
}

