/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table;

import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseCell;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.component.ComponentDesignConverter;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.convert.ReportConverter;

public class TableDesignConverter
implements ComponentDesignConverter {
    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRComponentElement element) {
        TableComponent table = (TableComponent)element.getComponent();
        if (table == null) {
            return null;
        }
        JRBasePrintFrame frame = new JRBasePrintFrame(reportConverter.getDefaultStyleProvider());
        reportConverter.copyBaseAttributes(element, frame);
        TableUtil tableManager = new TableUtil(table, reportConverter.getReport());
        Map<BaseCell, Rectangle> cellBounds = tableManager.getCellBounds();
        for (Map.Entry<BaseCell, Rectangle> pair : cellBounds.entrySet()) {
            List<JRChild> children;
            BaseCell cell = pair.getKey();
            Rectangle rectangle = pair.getValue();
            JRBasePrintFrame cellFrame = new JRBasePrintFrame(reportConverter.getDefaultStyleProvider());
            cellFrame.setX((int)rectangle.getX());
            cellFrame.setY((int)rectangle.getY());
            cellFrame.setWidth((int)rectangle.getWidth());
            cellFrame.setHeight((int)rectangle.getHeight());
            cellFrame.setStyle(reportConverter.resolveStyle(cell));
            if (cell.getLineBox() != null) {
                cellFrame.copyBox(cell.getLineBox());
            }
            if ((children = cell.getChildren()) != null && children.size() > 0) {
                ConvertVisitor convertVisitor = new ConvertVisitor(reportConverter, cellFrame);
                for (int i = 0; i < children.size(); ++i) {
                    children.get(i).visit(convertVisitor);
                }
            }
            frame.addElement(cellFrame);
        }
        return frame;
    }
}

