/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;

public final class JRQueryExecuterUtils {
    public static final String EXCEPTION_MESSAGE_KEY_QUERY_EXECUTER_FACTORY_NOT_REGISTERED = "util.query.executer.factory.not.registered";
    private JasperReportsContext jasperReportsContext;

    private JRQueryExecuterUtils(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static JRQueryExecuterUtils getInstance(JasperReportsContext jasperReportsContext) {
        return new JRQueryExecuterUtils(jasperReportsContext);
    }

    public QueryExecuterFactory getExecuterFactory(String language) throws JRException {
        List<JRQueryExecuterFactoryBundle> bundles = this.jasperReportsContext.getExtensions(JRQueryExecuterFactoryBundle.class);
        for (JRQueryExecuterFactoryBundle bundle : bundles) {
            QueryExecuterFactory factory = bundle.getQueryExecuterFactory(language);
            if (factory == null) continue;
            return factory;
        }
        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_QUERY_EXECUTER_FACTORY_NOT_REGISTERED, language);
    }
}

