/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.struts2.config.ConfigurationException;
import org.apache.struts2.config.entities.ActionConfig;
import org.apache.struts2.config.entities.PackageConfig;
import org.apache.struts2.config.entities.ResultTypeConfig;
import org.apache.struts2.convention.ConventionsService;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.util.AnnotationUtils;
import org.apache.struts2.util.ClassLoaderUtil;

public class ConventionsServiceImpl
implements ConventionsService {
    private String resultPath;

    @Inject
    public ConventionsServiceImpl(@Inject(value="struts.convention.result.path") String resultPath) {
        this.resultPath = resultPath;
    }

    @Override
    public String determineResultPath(Class<?> actionClass) {
        String localResultPath = this.resultPath;
        ResultPath resultPathAnnotation = (ResultPath)AnnotationUtils.findAnnotation(actionClass, ResultPath.class);
        if (resultPathAnnotation != null) {
            if (resultPathAnnotation.value().equals("") && resultPathAnnotation.property().equals("")) {
                throw new ConfigurationException("The ResultPath annotation must have either a value or property specified.");
            }
            String property = resultPathAnnotation.property();
            if (property.equals("")) {
                localResultPath = resultPathAnnotation.value();
            } else {
                try {
                    ResourceBundle strutsBundle = ResourceBundle.getBundle("struts");
                    localResultPath = strutsBundle.getString(property);
                }
                catch (Exception e) {
                    throw new ConfigurationException("The action class [" + String.valueOf(actionClass) + "] defines a @ResultPath annotation and a property definition however the struts.properties could not be found in the classpath using ResourceBundle OR the bundle exists but the property [" + property + "] is not defined in the file.", (Throwable)e);
                }
            }
        }
        return localResultPath;
    }

    @Override
    public String determineResultPath(ActionConfig actionConfig) {
        if (actionConfig == null) {
            return this.resultPath;
        }
        try {
            return this.determineResultPath(ClassLoaderUtil.loadClass((String)actionConfig.getClassName(), this.getClass()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Invalid action class configuration that references an unknown class named [" + actionConfig.getClassName() + "]", e);
        }
    }

    @Override
    public Map<String, ResultTypeConfig> getResultTypesByExtension(PackageConfig packageConfig) {
        Map results = packageConfig.getAllResultTypeConfigs();
        ResultTypeConfig dispatcher = this.disableParse((ResultTypeConfig)results.get("dispatcher"));
        ResultTypeConfig velocity = this.disableParse((ResultTypeConfig)results.get("velocity"));
        ResultTypeConfig freemarker = this.disableParse((ResultTypeConfig)results.get("freemarker"));
        HashMap<String, ResultTypeConfig> resultsByExtension = new HashMap<String, ResultTypeConfig>();
        resultsByExtension.put("jsp", dispatcher);
        resultsByExtension.put("jspf", dispatcher);
        resultsByExtension.put("jspx", dispatcher);
        resultsByExtension.put("vm", velocity);
        resultsByExtension.put("ftl", freemarker);
        resultsByExtension.put("html", dispatcher);
        resultsByExtension.put("htm", dispatcher);
        return resultsByExtension;
    }

    private ResultTypeConfig disableParse(ResultTypeConfig resultConfig) {
        if (resultConfig != null) {
            return new ResultTypeConfig.Builder(resultConfig).addParam("parse", "false").build();
        }
        return null;
    }
}

