/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.InvalidFontException;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwtFontManager {
    public static final String PROPERTY_USE_OWN_TEMP_FILE = "net.sf.jasperreports.font.use.own.temp.file";
    private static final Log log = LogFactory.getLog(AwtFontManager.class);
    private static final AwtFontManager INSTANCE = new AwtFontManager();
    private Map<FontFileReference, Object> fontFileReferences = new ConcurrentHashMap<FontFileReference, Object>();
    private ReferenceQueue<Font> fontFilesQueue = new ReferenceQueue();

    public static AwtFontManager instance() {
        return INSTANCE;
    }

    public Font getAwtFont(JasperReportsContext jasperReportsContext, String ttfLocation) {
        boolean useOwnFile = JRPropertiesUtil.getInstance(jasperReportsContext).getBooleanProperty(PROPERTY_USE_OWN_TEMP_FILE, false);
        this.purgeFontFiles();
        InputStream is = null;
        try {
            Font font;
            is = RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(ttfLocation);
            if (useOwnFile) {
                Path fontFile = Files.createTempFile("jr-font", ".ttf", new FileAttribute[0]);
                fontFile.toFile().deleteOnExit();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("created font file " + fontFile + " for " + ttfLocation));
                }
                Files.copy(is, fontFile, StandardCopyOption.REPLACE_EXISTING);
                font = Font.createFont(0, fontFile.toFile());
                FontFileReference fontFileReference = new FontFileReference(font, this.fontFilesQueue, fontFile);
                this.fontFileReferences.put(fontFileReference, Boolean.TRUE);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("created font for " + ttfLocation));
                }
                font = Font.createFont(0, is);
            }
            Font font2 = font;
            return font2;
        }
        catch (FontFormatException | IOException | JRException e) {
            throw new InvalidFontException(ttfLocation, e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void purgeFontFiles() {
        FontFileReference fontFileRef;
        while ((fontFileRef = (FontFileReference)this.fontFilesQueue.poll()) != null) {
            this.fontFileReferences.remove(fontFileRef);
            try {
                Files.deleteIfExists(fontFileRef.fontFile);
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Failed to delete font file " + fontFileRef.fontFile));
            }
        }
    }

    private static class FontFileReference
    extends WeakReference<Font> {
        Path fontFile;

        FontFileReference(Font font, ReferenceQueue<Font> queue, Path fontFile) {
            super(font, queue);
            this.fontFile = fontFile;
        }
    }
}

