/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public abstract class VirtualizationSerializer {
    public final void writeData(JRVirtualizable o, OutputStream out) throws IOException {
        Object virtualData = o.getVirtualData();
        JRVirtualizationContext context = o.getContext();
        this.writeData(virtualData, context, out);
    }

    public final void writeData(Object virtualData, JRVirtualizationContext context, OutputStream out) throws IOException {
        VirtualizationOutput oos = this.createOutput(context, out);
        oos.writeJRObject(virtualData);
        oos.flush();
    }

    protected abstract VirtualizationOutput createOutput(JRVirtualizationContext var1, OutputStream var2) throws IOException;

    public final void readData(JRVirtualizable o, InputStream in) throws IOException {
        Object virtualData = this.readData(o.getContext(), in);
        o.setVirtualData(virtualData);
    }

    public final Object readData(JRVirtualizationContext context, InputStream in) throws IOException {
        VirtualizationInput ois = this.createInput(context, in);
        Object readObject = ois.readJRObject();
        return readObject;
    }

    protected abstract VirtualizationInput createInput(JRVirtualizationContext var1, InputStream var2) throws IOException;
}

