/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.locale;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.request.locale.PostfixedApplicationResource;

public class URLApplicationResource
extends PostfixedApplicationResource {
    static final String REMOTE_PROTOCOLS_PROPERTY = "tiles.remoteProtocols";
    private static final Logger LOG = LogManager.getLogger(URLApplicationResource.class);
    private static final Set<String> REMOTE_PROTOCOLS = URLApplicationResource.initRemoteProtocols();
    private final URL url;
    private File file;
    private final boolean local;

    static Set<String> initRemoteProtocols() {
        HashSet<String> remoteProtocols = new HashSet<String>();
        remoteProtocols.add("ftp");
        remoteProtocols.add("http");
        remoteProtocols.add("https");
        String protocolsProp = System.getProperty(REMOTE_PROTOCOLS_PROPERTY);
        if (protocolsProp != null) {
            for (String protocol : protocolsProp.split(";")) {
                remoteProtocols.add(protocol.trim());
            }
        }
        return Collections.unmodifiableSet(remoteProtocols);
    }

    private boolean isLocal(URL url) {
        return !REMOTE_PROTOCOLS.contains(url.getProtocol());
    }

    public URLApplicationResource(String localePath, URL url) {
        super(localePath);
        this.url = url;
        if ("file".equals(url.getProtocol())) {
            this.file = this.getFile(url);
        }
        this.local = this.isLocal(url);
    }

    public URLApplicationResource(String path, Locale locale, URL url) {
        super(path, locale);
        this.url = url;
        if ("file".equals(url.getProtocol())) {
            this.file = this.getFile(url);
        }
        this.local = this.isLocal(url);
    }

    private URLConnection openConnection() throws IOException {
        try {
            return this.url.openConnection();
        }
        catch (IOException e) {
            if (this.local) {
                FileNotFoundException fne = new FileNotFoundException(this.url.toString());
                fne.initCause(e);
                throw fne;
            }
            throw e;
        }
    }

    private File getFile(URL url) {
        try {
            return new File(new URI(url.toExternalForm()).getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            LOG.debug("Cannot translate URL to file name, expect a performance impact", (Throwable)e);
            return null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            if (this.file.exists()) {
                return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            }
            throw new FileNotFoundException("File does not exist: " + String.valueOf(this.file));
        }
        return this.openConnection().getInputStream();
    }

    @Override
    public long getLastModified() throws IOException {
        if (this.file != null) {
            return this.file.lastModified();
        }
        URLConnection connection = this.openConnection();
        if (connection instanceof JarURLConnection) {
            return ((JarURLConnection)connection).getJarEntry().getTime();
        }
        return connection.getLastModified();
    }

    public String toString() {
        return "Resource " + this.getLocalePath() + " at " + this.url.toString();
    }
}

