/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGenerator;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.schema.XMLSchemaParser;
import org.apache.openjpa.jdbc.schema.XMLSchemaSerializer;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.jdbc.DelegatingDataSource;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Files;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.util.InvalidStateException;

public class SchemaTool {
    public static final String ACTION_ADD = "add";
    public static final String ACTION_DROP = "drop";
    public static final String ACTION_DROP_SCHEMA = "dropSchema";
    public static final String ACTION_RETAIN = "retain";
    public static final String ACTION_REFRESH = "refresh";
    public static final String ACTION_BUILD = "build";
    public static final String ACTION_REFLECT = "reflect";
    public static final String ACTION_CREATEDB = "createDB";
    public static final String ACTION_DROPDB = "dropDB";
    public static final String ACTION_IMPORT = "import";
    public static final String ACTION_EXPORT = "export";
    public static final String ACTION_DELETE_TABLE_CONTENTS = "deleteTableContents";
    public static final String ACTION_EXECUTE_SCRIPT = "executeScript";
    public static final String[] ACTIONS = new String[]{"add", "drop", "dropSchema", "retain", "refresh", "build", "reflect", "createDB", "dropDB", "import", "export", "deleteTableContents", "executeScript"};
    protected static final Localizer _loc = Localizer.forPackage(SchemaTool.class);
    protected final JDBCConfiguration _conf;
    protected final DataSource _ds;
    protected final Log _log;
    protected final DBDictionary _dict;
    private final String _action;
    private boolean _ignoreErrs = false;
    private boolean _openjpaTables = false;
    private boolean _dropTables = true;
    private boolean _dropSeqs = true;
    private boolean _pks = true;
    private boolean _fks = true;
    private boolean _indexes = true;
    private boolean _seqs = true;
    private boolean _rollbackBeforeDDL = true;
    private PrintWriter _writer = null;
    private SchemaGroup _group = null;
    private SchemaGroup _db = null;
    protected boolean _fullDB = false;
    protected String _sqlTerminator = ";";
    protected String _scriptToExecute = null;

    public SchemaTool(JDBCConfiguration conf) {
        this(conf, null);
    }

    public SchemaTool(JDBCConfiguration conf, String action) {
        if (action != null && !Arrays.asList(ACTIONS).contains(action)) {
            Configurations.configureInstance((Object)this, (Configuration)conf, (String)action, (String)action);
        }
        this._conf = conf;
        this._action = action;
        this._ds = ACTION_BUILD.equals(action) ? null : conf.getDataSource2(null);
        this._log = conf.getLog("openjpa.jdbc.Schema");
        this._dict = this._conf.getDBDictionaryInstance();
    }

    public void clear() {
        if (this._ds != null && this._ds instanceof DelegatingDataSource) {
            try {
                ((DelegatingDataSource)this._ds).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getAction() {
        return this._action;
    }

    public boolean getIgnoreErrors() {
        return this._ignoreErrs;
    }

    public void setIgnoreErrors(boolean ignoreErrs) {
        this._ignoreErrs = ignoreErrs;
    }

    public boolean getOpenJPATables() {
        return this._openjpaTables;
    }

    public void setOpenJPATables(boolean openjpaTables) {
        this._openjpaTables = openjpaTables;
    }

    public boolean getDropTables() {
        return this._dropTables;
    }

    public void setDropTables(boolean dropTables) {
        this._dropTables = dropTables;
    }

    public boolean getDropSequences() {
        return this._dropSeqs;
    }

    public void setDropSequences(boolean dropSeqs) {
        this._dropSeqs = dropSeqs;
        if (dropSeqs) {
            this.setSequences(true);
        }
    }

    public boolean getRollbackBeforeDDL() {
        return this._rollbackBeforeDDL;
    }

    public void setRollbackBeforeDDL(boolean rollbackBeforeDDL) {
        this._rollbackBeforeDDL = rollbackBeforeDDL;
    }

    public boolean getSequences() {
        return this._seqs;
    }

    public void setSequences(boolean seqs) {
        this._seqs = seqs;
    }

    public boolean getIndexes() {
        return this._indexes;
    }

    public void setIndexes(boolean indexes) {
        this._indexes = indexes;
    }

    public boolean getForeignKeys() {
        return this._fks;
    }

    public void setForeignKeys(boolean fks) {
        this._fks = fks;
    }

    public boolean getPrimaryKeys() {
        return this._pks;
    }

    public void setPrimaryKeys(boolean pks) {
        this._pks = pks;
    }

    public Writer getWriter() {
        return this._writer;
    }

    public void setWriter(Writer writer) {
        this._writer = writer == null ? null : (writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer));
    }

    public void setSQLTerminator(String t) {
        this._sqlTerminator = t;
    }

    public void setScriptToExecute(String scriptToExecute) {
        this._scriptToExecute = scriptToExecute;
    }

    public SchemaGroup getSchemaGroup() {
        return this._group;
    }

    public void setSchemaGroup(SchemaGroup group) {
        this._group = group;
    }

    public void run() throws SQLException {
        if (this._action == null) {
            return;
        }
        if (ACTION_ADD.equals(this._action)) {
            this.add();
        } else if (ACTION_DROP.equals(this._action)) {
            this.drop();
        } else if (ACTION_DROP_SCHEMA.equals(this._action)) {
            this.dropSchema();
        } else if (ACTION_RETAIN.equals(this._action)) {
            this.retain();
        } else if (ACTION_REFRESH.equals(this._action)) {
            this.refresh();
        } else if (ACTION_BUILD.equals(this._action)) {
            this.build();
        } else if (ACTION_CREATEDB.equals(this._action)) {
            this.createDB();
        } else if (ACTION_DROPDB.equals(this._action)) {
            this.dropDB();
        } else if (ACTION_DELETE_TABLE_CONTENTS.equals(this._action)) {
            this.deleteTableContents();
        } else if (ACTION_EXECUTE_SCRIPT.equals(this._action)) {
            this.executeScript();
        }
    }

    protected void add() throws SQLException {
        this.add(this.getDBSchemaGroup(false), this.assertSchemaGroup());
    }

    protected void drop() throws SQLException {
        this.drop(this.getDBSchemaGroup(false), this.assertSchemaGroup());
    }

    protected void dropSchema() throws SQLException {
        this.drop(this.getDBSchemaGroup(false), this.assertSchemaGroup(), false);
    }

    protected void retain() throws SQLException {
        this.retain(this.getDBSchemaGroup(true), this.assertSchemaGroup(), this.getDropTables(), this.getDropSequences());
    }

    protected void refresh() throws SQLException {
        SchemaGroup local = this.assertSchemaGroup();
        SchemaGroup db = this.getDBSchemaGroup(true);
        this.retain(db, local, this.getDropTables(), this.getDropSequences());
        this.add(db, local);
    }

    protected void createDB() throws SQLException {
        SchemaGroup group = new SchemaGroup();
        group.addSchema();
        this.add(group, this.getDBSchemaGroup(true));
    }

    protected void build() throws SQLException {
        SchemaGroup group = new SchemaGroup();
        group.addSchema();
        this.buildSchema(group, this.assertSchemaGroup(), true);
    }

    protected void dropDB() throws SQLException {
        this.retain(this.getDBSchemaGroup(true), new SchemaGroup(), true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTableContents() throws SQLException {
        SchemaGroup group = this.getSchemaGroup();
        Schema[] schemas = group.getSchemas();
        LinkedHashSet<Table> tables = new LinkedHashSet<Table>();
        for (Schema schema : schemas) {
            Table[] ts;
            for (Table t : ts = schema.getTables()) {
                tables.add(t);
            }
        }
        Table[] tableArray = tables.toArray(new Table[tables.size()]);
        Connection conn = this._ds.getConnection();
        try {
            String[] sql = this._conf.getDBDictionaryInstance().getDeleteTableContentsSQL(tableArray, conn);
            if (!this.executeSQL(sql)) {
                this._log.warn((Object)_loc.get("delete-table-contents"));
            }
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeScript() throws SQLException {
        if (this._scriptToExecute == null) {
            this._log.warn((Object)_loc.get("generating-execute-script-not-defined"));
            return;
        }
        URL url = (URL)AccessController.doPrivileged(J2DoPrivHelper.getResourceAction((ClassLoader)this._conf.getClassResolverInstance().getClassLoader(SchemaTool.class, null), (String)this._scriptToExecute));
        if (url == null) {
            this._log.error((Object)_loc.get("generating-execute-script-not-found", (Object)this._scriptToExecute));
            return;
        }
        this._log.info((Object)_loc.get("generating-execute-script", (Object)this._scriptToExecute));
        BufferedReader reader = null;
        try {
            String sql;
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            ArrayList<String> script = new ArrayList<String>();
            while ((sql = reader.readLine()) != null) {
                if ((sql = sql.trim()).startsWith("--") || sql.startsWith("/*") || sql.startsWith("//")) continue;
                int semiColonPosition = sql.indexOf(";");
                if (sql.endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1);
                }
                if (sql.isEmpty()) continue;
                script.add(sql);
            }
            this.executeSQL(script.toArray(new String[script.size()]));
        }
        catch (IOException e) {
            this._log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                this._log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void record() {
        if (this._db != null && this._writer == null) {
            this._conf.getSchemaFactoryInstance().storeSchema(this._db);
        }
    }

    protected void add(SchemaGroup db, SchemaGroup repos) throws SQLException {
        this.buildSchema(db, repos, true);
    }

    /*
     * WARNING - void declaration
     */
    protected void buildSchema(SchemaGroup db, SchemaGroup repos, boolean considerDatabaseState) throws SQLException {
        void var14_26;
        int n;
        Table[] tabs;
        Schema schema;
        Schema[] schemas = repos.getSchemas();
        if (this._seqs) {
            for (Schema value : schemas) {
                Sequence[] seqs = value.getSequences();
                for (Comparable<Schema> comparable : seqs) {
                    if (considerDatabaseState && db.findSequence(value, ((Sequence)comparable).getQualifiedPath()) != null) continue;
                    if (this.createSequence((Sequence)comparable)) {
                        schema = db.getSchema(((Sequence)comparable).getSchemaIdentifier());
                        if (schema == null) {
                            schema = db.addSchema(((Sequence)comparable).getSchemaIdentifier());
                        }
                        schema.importSequence((Sequence)comparable);
                        continue;
                    }
                    this._log.warn((Object)_loc.get("add-seq", comparable));
                }
            }
        }
        Table dbTable = null;
        DBIdentifier defaultSchemaName = DBIdentifier.newSchema(this._dict.getDefaultSchemaName());
        for (Schema schema2 : schemas) {
            for (Table tab : tabs = schema2.getTables()) {
                Column[] cols = tab.getColumns();
                if (considerDatabaseState) {
                    dbTable = db.findTable(schema2, tab.getQualifiedPath(), defaultSchemaName);
                }
                Column[] columnArray = cols;
                int n2 = columnArray.length;
                for (int i = 0; i < n2; ++i) {
                    Index[] column = columnArray[i];
                    if (dbTable == null) continue;
                    DBIdentifier colName = column.getIdentifier();
                    Column col = dbTable.getColumn(colName);
                    if (col == null) {
                        if (this.addColumn((Column)column)) {
                            dbTable.importColumn((Column)column);
                            continue;
                        }
                        this._log.warn((Object)_loc.get("add-col", (Object)column, (Object)tab));
                        continue;
                    }
                    if (column.equalsColumn(this._dict, col)) continue;
                    this._log.warn((Object)_loc.get("bad-col", new Object[]{col, dbTable, col.getDescription(), column.getDescription()}));
                }
            }
        }
        if (this._pks) {
            void var14_24;
            Schema[] schemaArray = schemas;
            n = schemaArray.length;
            boolean bl = false;
            while (var14_24 < n) {
                Schema value = schemaArray[var14_24];
                for (Table tab : tabs = value.getTables()) {
                    PrimaryKey pk = tab.getPrimaryKey();
                    if (considerDatabaseState) {
                        dbTable = db.findTable(value, tab.getQualifiedPath());
                    }
                    if (pk == null || pk.isLogical() || dbTable == null) continue;
                    if (dbTable.getPrimaryKey() == null && this.addPrimaryKey(pk)) {
                        dbTable.importPrimaryKey(pk);
                        continue;
                    }
                    if (dbTable.getPrimaryKey() == null) {
                        this._log.warn((Object)_loc.get("add-pk", (Object)pk, (Object)tab));
                        continue;
                    }
                    if (pk.equalsPrimaryKey(dbTable.getPrimaryKey())) continue;
                    this._log.warn((Object)_loc.get("bad-pk", (Object)dbTable.getPrimaryKey(), (Object)dbTable));
                }
                ++var14_24;
            }
        }
        HashSet<Table> newTables = new HashSet<Table>();
        Schema[] schemaArray = schemas;
        n = schemaArray.length;
        boolean bl = false;
        while (var14_26 < n) {
            Schema schema1 = schemaArray[var14_26];
            for (Table tab : tabs = schema1.getTables()) {
                if (considerDatabaseState && db.findTable(schema1, tab.getQualifiedPath()) != null) continue;
                if (this.createTable(tab)) {
                    newTables.add(tab);
                    schema = db.getSchema(tab.getSchemaIdentifier());
                    if (schema == null) {
                        schema = db.addSchema(tab.getSchemaIdentifier());
                    }
                    schema.importTable(tab);
                    continue;
                }
                this._log.warn((Object)_loc.get("add-table", (Object)tab));
            }
            ++var14_26;
        }
        for (Schema element : schemas) {
            for (Table tab : tabs = element.getTables()) {
                if (!this._indexes && !newTables.contains(tab)) continue;
                Index[] idxs = tab.getIndexes();
                if (considerDatabaseState) {
                    dbTable = db.findTable(element, tab.getQualifiedPath());
                }
                for (Index index : idxs) {
                    if (dbTable == null) continue;
                    Index idx = this.findIndex(dbTable, index);
                    if (idx == null) {
                        if (this.createIndex(index, dbTable, tab.getUniques())) {
                            dbTable.importIndex(index);
                            continue;
                        }
                        this._log.warn((Object)_loc.get("add-index", (Object)index, (Object)tab));
                        continue;
                    }
                    if (index.equalsIndex(idx)) continue;
                    this._log.warn((Object)_loc.get("bad-index", (Object)idx, (Object)dbTable));
                }
            }
        }
        for (Schema item : schemas) {
            for (Table tab : tabs = item.getTables()) {
                Unique[] uniqueArray;
                if (!newTables.contains(tab) || (uniqueArray = tab.getUniques()) == null || uniqueArray.length == 0) continue;
                if (considerDatabaseState) {
                    dbTable = db.findTable(tab);
                }
                if (dbTable == null) continue;
                for (Unique unique : uniqueArray) {
                    dbTable.importUnique(unique);
                }
            }
        }
        for (Schema value : schemas) {
            for (Table tab : tabs = value.getTables()) {
                if (!this._fks && !newTables.contains(tab)) continue;
                ForeignKey[] fks = tab.getForeignKeys();
                if (considerDatabaseState) {
                    dbTable = db.findTable(value, tab.getQualifiedPath());
                }
                for (ForeignKey foreignKey : fks) {
                    if (foreignKey.isLogical() || dbTable == null) continue;
                    ForeignKey fk = this.findForeignKey(dbTable, foreignKey);
                    if (fk == null) {
                        if (this.addForeignKey(foreignKey)) {
                            dbTable.importForeignKey(foreignKey);
                            continue;
                        }
                        this._log.warn((Object)_loc.get("add-fk", (Object)foreignKey, (Object)tab));
                        continue;
                    }
                    if (foreignKey.equalsForeignKey(fk)) continue;
                    this._log.warn((Object)_loc.get("bad-fk", (Object)fk, (Object)dbTable));
                }
            }
        }
    }

    protected void retain(SchemaGroup db, SchemaGroup repos, boolean tables, boolean sequences) throws SQLException {
        Table reposTable;
        Table[] tabs;
        Object seq;
        Schema[] schemas = db.getSchemas();
        if (this._seqs && sequences) {
            for (Schema schema : schemas) {
                Sequence[] seqs;
                Sequence[] sequenceArray = seqs = schema.getSequences();
                int n = sequenceArray.length;
                for (int i = 0; i < n; ++i) {
                    seq = sequenceArray[i];
                    if (!this.isDroppable((Sequence)seq) || repos.findSequence((Sequence)seq) != null) continue;
                    if (this.dropSequence((Sequence)seq)) {
                        schema.removeSequence((Sequence)seq);
                        continue;
                    }
                    this._log.warn((Object)_loc.get("drop-seq", seq));
                }
            }
        }
        if (this._fks) {
            for (Schema schema : schemas) {
                seq = tabs = schema.getTables();
                int n = ((Table[])seq).length;
                for (int i = 0; i < n; ++i) {
                    Table tab = seq[i];
                    if (!this.isDroppable(tab)) continue;
                    ForeignKey[] fks = tab.getForeignKeys();
                    reposTable = repos.findTable(tab);
                    if (!tables && reposTable == null) continue;
                    for (ForeignKey foreignKey : fks) {
                        if (foreignKey.isLogical()) continue;
                        ForeignKey fk = null;
                        if (reposTable != null) {
                            fk = this.findForeignKey(reposTable, foreignKey);
                        }
                        if (reposTable != null && fk != null && foreignKey.equalsForeignKey(fk)) continue;
                        if (this.dropForeignKey(foreignKey)) {
                            tab.removeForeignKey(foreignKey);
                            continue;
                        }
                        this._log.warn((Object)_loc.get("drop-fk", (Object)foreignKey, (Object)tab));
                    }
                }
            }
        }
        if (this._pks) {
            for (Schema schema : schemas) {
                for (Table tab : tabs = schema.getTables()) {
                    PrimaryKey pk;
                    if (!this.isDroppable(tab) || (pk = tab.getPrimaryKey()) != null && pk.isLogical()) continue;
                    reposTable = repos.findTable(tab);
                    if (pk == null || reposTable == null || reposTable.getPrimaryKey() != null && pk.equalsPrimaryKey(reposTable.getPrimaryKey())) continue;
                    if (this.dropPrimaryKey(pk)) {
                        tab.removePrimaryKey();
                        continue;
                    }
                    this._log.warn((Object)_loc.get("drop-pk", (Object)pk, (Object)tab));
                }
            }
        }
        LinkedList<Table> drops = new LinkedList<Table>();
        for (Schema value : schemas) {
            for (Table tab : tabs = value.getTables()) {
                if (!this.isDroppable(tab)) continue;
                Column[] cols = tab.getColumns();
                reposTable = repos.findTable(tab);
                if (reposTable == null) continue;
                for (Column column : cols) {
                    Column col = reposTable.getColumn(column.getIdentifier());
                    if (col != null && column.equalsColumn(this._dict, col)) continue;
                    if (tab.getColumns().length == 1) {
                        drops.add(tab);
                        continue;
                    }
                    if (this.dropColumn(column)) {
                        tab.removeColumn(column);
                        continue;
                    }
                    this._log.warn((Object)_loc.get("drop-col", (Object)column, (Object)tab));
                }
            }
        }
        if (tables) {
            for (Schema schema : schemas) {
                for (Table tab : tabs = schema.getTables()) {
                    if (!this.isDroppable(tab) || repos.findTable(tab) != null) continue;
                    drops.add(tab);
                }
            }
        }
        this.dropTables(drops, db);
    }

    protected void drop(SchemaGroup db, SchemaGroup repos) throws SQLException {
        this.drop(db, repos, true);
    }

    private void drop(SchemaGroup db, SchemaGroup repos, boolean considerDatabaseState) throws SQLException {
        Table dbTable;
        Table[] tabs;
        Schema[] schemas = repos.getSchemas();
        if (this._seqs) {
            for (Schema schema : schemas) {
                Sequence[] seqs;
                for (Sequence seq : seqs = schema.getSequences()) {
                    if (!this.isDroppable(seq)) continue;
                    Sequence dbSeq = db.findSequence(seq);
                    if (dbSeq != null) {
                        if (this.dropSequence(seq)) {
                            dbSeq.getSchema().removeSequence(dbSeq);
                            continue;
                        }
                        this._log.warn((Object)_loc.get("drop-seq", (Object)seq));
                        continue;
                    }
                    if (this._writer == null) continue;
                    this.dropSequence(seq);
                }
            }
        }
        LinkedList<Table> drops = new LinkedList<Table>();
        for (Schema value : schemas) {
            block3: for (Table tab : tabs = value.getTables()) {
                Column[] dbCols;
                if (!this.isDroppable(tab)) continue;
                if (!considerDatabaseState) {
                    drops.add(tab);
                    continue;
                }
                dbTable = db.findTable(tab);
                if (dbTable == null) {
                    if (this._writer == null) continue;
                    drops.add(tab);
                    continue;
                }
                for (Column dbCol : dbCols = dbTable.getColumns()) {
                    if (!dbCol.getIdentifier().getName().equals(this._dict.getIdentityColumnName()) && !tab.containsColumn(dbCol)) continue block3;
                }
                drops.add(tab);
            }
        }
        if (this._fks) {
            ForeignKey[] fks;
            for (Schema schema : schemas) {
                for (Table tab : tabs = schema.getTables()) {
                    if (!this.isDroppable(tab)) continue;
                    fks = tab.getForeignKeys();
                    dbTable = db.findTable(tab);
                    ForeignKey[] foreignKeyArray = fks;
                    int n = foreignKeyArray.length;
                    for (int i = 0; i < n; ++i) {
                        ForeignKey foreignKey = foreignKeyArray[i];
                        if (foreignKey.isLogical()) continue;
                        ForeignKey fk = null;
                        if (dbTable != null) {
                            fk = this.findForeignKey(dbTable, foreignKey);
                        }
                        if (dbTable == null || fk == null || !this.dropForeignKey(foreignKey)) continue;
                        if (dbTable != null) {
                            dbTable.removeForeignKey(fk);
                            continue;
                        }
                        this._log.warn((Object)_loc.get("drop-fk", (Object)foreignKey, (Object)tab));
                    }
                }
            }
            for (Table drop : drops) {
                Table tab = drop;
                dbTable = db.findTable(tab);
                if (dbTable == null) continue;
                for (ForeignKey foreignKey : fks = db.findExportedForeignKeys(dbTable.getPrimaryKey())) {
                    if (this.dropForeignKey(foreignKey)) {
                        dbTable.removeForeignKey(foreignKey);
                        continue;
                    }
                    this._log.warn((Object)_loc.get("drop-fk", (Object)foreignKey, (Object)dbTable));
                }
            }
        }
        this.dropTables(drops, db);
        if (considerDatabaseState) {
            for (Schema schema : schemas) {
                for (Table tab : tabs = schema.getTables()) {
                    if (!this.isDroppable(tab)) continue;
                    Column[] cols = tab.getColumns();
                    dbTable = db.findTable(tab);
                    for (Column column : cols) {
                        Column col = null;
                        if (dbTable != null) {
                            col = dbTable.getColumn(column.getIdentifier());
                        }
                        if (dbTable == null || col == null || !this.dropColumn(column)) continue;
                        dbTable.removeColumn(col);
                    }
                }
            }
        }
    }

    protected boolean isDroppable(Table table) {
        return this._openjpaTables || !DBIdentifier.toUpper(table.getIdentifier()).getName().startsWith("OPENJPA_") && !DBIdentifier.toUpper(table.getIdentifier()).getName().startsWith("JDO_");
    }

    protected boolean isDroppable(Sequence seq) {
        return this._openjpaTables || !DBIdentifier.toUpper(seq.getIdentifier()).getName().startsWith("OPENJPA_") && !DBIdentifier.toUpper(seq.getIdentifier()).getName().startsWith("JDO_");
    }

    protected Index findIndex(Table dbTable, Index idx) {
        Index[] idxs;
        for (Index index : idxs = dbTable.getIndexes()) {
            if (!idx.columnsMatch(index.getColumns())) continue;
            return index;
        }
        return null;
    }

    protected ForeignKey findForeignKey(Table dbTable, ForeignKey fk) {
        ForeignKey[] fks;
        if (fk.getConstantColumns().length > 0 || fk.getConstantPrimaryKeyColumns().length > 0) {
            return null;
        }
        for (ForeignKey foreignKey : fks = dbTable.getForeignKeys()) {
            if (!fk.columnsMatch(foreignKey.getColumns(), foreignKey.getPrimaryKeyColumns())) continue;
            return foreignKey;
        }
        return null;
    }

    protected void dropTables(Collection<Table> tables, SchemaGroup change) throws SQLException {
        if (tables.isEmpty()) {
            return;
        }
        for (Table value : tables) {
            Table table = value;
            if (this.dropTable(table)) {
                Table changeTable = change.findTable(table);
                if (changeTable == null) continue;
                changeTable.getSchema().removeTable(changeTable);
                continue;
            }
            this._log.warn((Object)_loc.get("drop-table", (Object)table));
        }
    }

    public boolean createTable(Table table) throws SQLException {
        return this.executeSQL(this._dict.getCreateTableSQL(table, this._db));
    }

    public boolean dropTable(Table table) throws SQLException {
        return this.executeSQL(this._dict.getDropTableSQL(table));
    }

    public boolean createSequence(Sequence seq) throws SQLException {
        return this.executeSQL(this._dict.getCreateSequenceSQL(seq));
    }

    public boolean dropSequence(Sequence seq) throws SQLException {
        return this.executeSQL(this._dict.getDropSequenceSQL(seq));
    }

    public boolean createIndex(Index idx, Table table) throws SQLException {
        return this.createIndex(idx, table, null);
    }

    public boolean createIndex(Index idx, Table table, Unique[] uniques) throws SQLException {
        if (!this._dict.needsToCreateIndex(idx, table, uniques)) {
            return false;
        }
        int max = this._dict.maxIndexesPerTable;
        int len = table.getIndexes().length;
        if (table.getPrimaryKey() != null) {
            len += table.getPrimaryKey().getColumns().length;
        }
        if (len >= max) {
            this._log.warn((Object)_loc.get("too-many-indexes", (Object)idx, (Object)table, (Object)(max + "")));
            return false;
        }
        return this.executeSQL(this._dict.getCreateIndexSQL(idx));
    }

    public boolean dropIndex(Index idx) throws SQLException {
        return this.executeSQL(this._dict.getDropIndexSQL(idx));
    }

    public boolean addColumn(Column col) throws SQLException {
        return this.executeSQL(this._dict.getAddColumnSQL(col));
    }

    public boolean dropColumn(Column col) throws SQLException {
        return this.executeSQL(this._dict.getDropColumnSQL(col));
    }

    public boolean addPrimaryKey(PrimaryKey pk) throws SQLException {
        return this.executeSQL(this._dict.getAddPrimaryKeySQL(pk));
    }

    public boolean dropPrimaryKey(PrimaryKey pk) throws SQLException {
        return this.executeSQL(this._dict.getDropPrimaryKeySQL(pk));
    }

    public boolean addForeignKey(ForeignKey fk) throws SQLException {
        return this.executeSQL(this._dict.getAddForeignKeySQL(fk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropForeignKey(ForeignKey fk) throws SQLException {
        Connection conn = this._ds.getConnection();
        try {
            boolean bl = this.executeSQL(this._dict.getDropForeignKeySQL(fk, conn));
            return bl;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public SchemaGroup getDBSchemaGroup() {
        try {
            return this.getDBSchemaGroup(true);
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, this._dict);
        }
    }

    public void setDBSchemaGroup(SchemaGroup db) {
        this._db = db;
        if (db != null) {
            this._fullDB = true;
        }
    }

    protected SchemaGroup getDBSchemaGroup(boolean full) throws SQLException {
        if (this._db == null || full && !this._fullDB) {
            SchemaGenerator gen = new SchemaGenerator(this._conf);
            gen.setPrimaryKeys(this._pks);
            gen.setForeignKeys(this._fks);
            gen.setIndexes(this._indexes);
            if (full) {
                gen.generateSchemas();
            } else {
                Schema[] schemas;
                LinkedList<DBIdentifier> tables = new LinkedList<DBIdentifier>();
                SchemaGroup group = this.assertSchemaGroup();
                for (Schema schema : schemas = group.getSchemas()) {
                    Table[] tabs;
                    for (Table tab : tabs = schema.getTables()) {
                        if (DBIdentifier.isNull(tab.getSchemaIdentifier())) {
                            tables.add(tab.getIdentifier());
                            continue;
                        }
                        DBIdentifier sName = tab.getFullIdentifier();
                        tables.add(sName);
                    }
                }
                if (!tables.isEmpty()) {
                    gen.generateSchemas(tables.toArray(new DBIdentifier[tables.size()]));
                }
            }
            this._db = gen.getSchemaGroup();
        }
        return this._db;
    }

    protected SchemaGroup assertSchemaGroup() {
        SchemaGroup local = this.getSchemaGroup();
        if (local == null) {
            throw new InvalidStateException(_loc.get("tool-norepos"));
        }
        return local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeSQL(String[] sql) throws SQLException {
        if (sql.length == 0) {
            return false;
        }
        boolean err = false;
        if (this._writer == null) {
            Connection conn = this._ds.getConnection();
            Statement statement = null;
            boolean wasAuto = true;
            try {
                if (this._rollbackBeforeDDL && !(wasAuto = conn.getAutoCommit())) {
                    conn.setAutoCommit(true);
                }
                for (String s : sql) {
                    try {
                        if (this._rollbackBeforeDDL) {
                            try {
                                conn.rollback();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        statement = conn.createStatement();
                        statement.executeUpdate(s);
                        try {
                            conn.commit();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    catch (SQLException se) {
                        err = true;
                        this.handleException(se);
                    }
                    finally {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
            }
            finally {
                if (this._rollbackBeforeDDL && !wasAuto) {
                    conn.setAutoCommit(false);
                }
                try {
                    this.closeConnection(conn);
                }
                catch (SQLException sQLException) {}
            }
        }
        for (String s : sql) {
            this._writer.println(s + this._sqlTerminator);
        }
        this._writer.flush();
        return !err;
    }

    protected void handleException(SQLException sql) throws SQLException {
        if (!this._ignoreErrs) {
            throw sql;
        }
        this._log.warn((Object)sql.getMessage(), (Throwable)sql);
    }

    public static void main(String[] args) throws IOException, SQLException {
        Options opts = new Options();
        final String[] arguments = opts.setFromCmdLine(args);
        boolean ret = Configurations.runAgainstAllAnchors((Options)opts, (Configurations.Runnable)new Configurations.Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run(Options opts) throws Exception {
                try (JDBCConfigurationImpl conf = new JDBCConfigurationImpl();){
                    boolean bl = SchemaTool.run(conf, arguments, opts);
                    return bl;
                }
            }
        });
        if (!ret) {
            System.out.println(_loc.get("tool-usage"));
        }
    }

    public static boolean run(JDBCConfiguration conf, String[] args, Options opts) throws IOException, SQLException {
        Flags flags = new Flags();
        flags.dropTables = opts.removeBooleanProperty("dropTables", "dt", flags.dropTables);
        flags.dropSequences = opts.removeBooleanProperty("dropSequences", "dsq", flags.dropSequences);
        flags.rollbackBeforeDDL = opts.removeBooleanProperty("rollbackBeforeDDL", "rbddl", flags.rollbackBeforeDDL);
        flags.ignoreErrors = opts.removeBooleanProperty("ignoreErrors", "i", flags.ignoreErrors);
        flags.openjpaTables = opts.removeBooleanProperty("openjpaTables", "ot", flags.openjpaTables);
        flags.primaryKeys = opts.removeBooleanProperty("primaryKeys", "pk", flags.primaryKeys);
        flags.foreignKeys = opts.removeBooleanProperty("foreignKeys", "fks", flags.foreignKeys);
        flags.indexes = opts.removeBooleanProperty("indexes", "ix", flags.indexes);
        flags.sequences = opts.removeBooleanProperty("sequences", "sq", flags.sequences);
        flags.record = opts.removeBooleanProperty("record", "r", flags.record);
        String fileName = opts.removeProperty("file", "f", null);
        String schemas = opts.removeProperty("s");
        if (schemas != null) {
            opts.setProperty("schemas", schemas);
        }
        String[] actions = opts.removeProperty("action", "a", flags.action).split(",");
        Configurations.populateConfiguration((Configuration)conf, (Options)opts);
        ClassLoader loader = conf.getClassResolverInstance().getClassLoader(SchemaTool.class, null);
        flags.writer = Files.getWriter((String)fileName, (ClassLoader)loader);
        boolean returnValue = true;
        String[] stringArray = actions;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String action;
            flags.action = action = stringArray[i];
            returnValue &= SchemaTool.run(conf, args, flags, loader);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean run(JDBCConfiguration conf, String[] args, Flags flags, ClassLoader loader) throws IOException, SQLException {
        SchemaGroup schema;
        Log log = conf.getLog("openjpa.Tool");
        if (ACTION_REFLECT.equals(flags.action)) {
            if (args.length > 0) {
                return false;
            }
            if (flags.writer == null) {
                flags.writer = new PrintWriter(System.out);
            }
            SchemaGenerator gen = new SchemaGenerator(conf);
            gen.setPrimaryKeys(flags.primaryKeys);
            gen.setIndexes(flags.indexes);
            gen.setForeignKeys(flags.foreignKeys);
            gen.setSequences(flags.sequences);
            gen.setOpenJPATables(flags.openjpaTables);
            String schemas = conf.getSchemas();
            if (StringUtil.isEmpty((String)schemas)) {
                schemas = "all";
            }
            log.info((Object)_loc.get("sch-reflect", (Object)schemas));
            gen.generateSchemas();
            log.info((Object)_loc.get("sch-reflect-write"));
            XMLSchemaSerializer ser = new XMLSchemaSerializer(conf);
            ser.addAll(gen.getSchemaGroup());
            ser.serialize(flags.writer, 1);
            return true;
        }
        if (!(args.length != 0 || ACTION_CREATEDB.equals(flags.action) || ACTION_DROPDB.equals(flags.action) || ACTION_EXPORT.equals(flags.action) || ACTION_DELETE_TABLE_CONTENTS.equals(flags.action))) {
            return false;
        }
        XMLSchemaParser parser = new XMLSchemaParser(conf);
        parser.setDelayConstraintResolve(true);
        for (String arg : args) {
            File file = Files.getFile((String)arg, (ClassLoader)loader);
            log.info((Object)_loc.get("tool-running", (Object)file));
            parser.parse(file);
        }
        parser.resolveConstraints();
        if (ACTION_IMPORT.equals(flags.action)) {
            log.info((Object)_loc.get("tool-import-store"));
            schema = parser.getSchemaGroup();
            conf.getSchemaFactoryInstance().storeSchema(schema);
            return true;
        }
        if (ACTION_EXPORT.equals(flags.action)) {
            if (flags.writer == null) {
                flags.writer = new PrintWriter(System.out);
            }
            log.info((Object)_loc.get("tool-export-gen"));
            schema = conf.getSchemaFactoryInstance().readSchema();
            log.info((Object)_loc.get("tool-export-write"));
            XMLSchemaSerializer ser = new XMLSchemaSerializer(conf);
            ser.addAll(schema);
            ser.serialize(flags.writer, 1);
            return true;
        }
        SchemaTool tool = new SchemaTool(conf, flags.action);
        tool.setIgnoreErrors(flags.ignoreErrors);
        tool.setDropTables(flags.dropTables);
        tool.setSequences(flags.sequences);
        tool.setDropSequences(flags.dropSequences);
        tool.setRollbackBeforeDDL(flags.rollbackBeforeDDL);
        tool.setPrimaryKeys(flags.primaryKeys);
        tool.setForeignKeys(flags.foreignKeys);
        tool.setIndexes(flags.indexes);
        tool.setOpenJPATables(flags.openjpaTables);
        if (args.length > 0) {
            tool.setSchemaGroup(parser.getSchemaGroup());
        }
        if (flags.writer != null) {
            tool.setWriter(flags.writer);
        }
        log.info((Object)_loc.get("tool-action", (Object)flags.action));
        try {
            tool.run();
        }
        finally {
            if (flags.record) {
                log.info((Object)_loc.get("tool-record"));
                tool.record();
            }
        }
        if (flags.writer != null) {
            flags.writer.flush();
        }
        return true;
    }

    private void closeConnection(Connection conn) throws SQLException {
        if (conn != null && !conn.isClosed()) {
            conn.close();
        }
    }

    public static class Flags {
        public String action = "add";
        public Writer writer = null;
        public boolean dropTables = true;
        public boolean rollbackBeforeDDL = true;
        public boolean dropSequences = true;
        public boolean ignoreErrors = false;
        public boolean openjpaTables = false;
        public boolean primaryKeys = true;
        public boolean foreignKeys = true;
        public boolean indexes = true;
        public boolean sequences = true;
        public boolean record = true;
    }
}

