/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.syncope.common.lib.to.AuthProfileTO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;

public class AuthProfileDataBinderImpl
implements AuthProfileDataBinder {
    protected final EntityFactory entityFactory;

    public AuthProfileDataBinderImpl(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public AuthProfileTO getAuthProfileTO(AuthProfile authProfile) {
        AuthProfileTO authProfileTO = new AuthProfileTO();
        authProfileTO.setKey(authProfile.getKey());
        authProfileTO.setOwner(authProfile.getOwner());
        authProfileTO.getImpersonationAccounts().addAll(authProfile.getImpersonationAccounts());
        authProfileTO.getGoogleMfaAuthTokens().addAll(authProfile.getGoogleMfaAuthTokens());
        authProfileTO.getGoogleMfaAuthAccounts().addAll(authProfile.getGoogleMfaAuthAccounts());
        authProfileTO.getU2FRegisteredDevices().addAll(authProfile.getU2FRegisteredDevices());
        authProfileTO.getMfaTrustedDevices().addAll(authProfile.getMfaTrustedDevices());
        authProfileTO.getWebAuthnDeviceCredentials().addAll(authProfile.getWebAuthnDeviceCredentials());
        return authProfileTO;
    }

    public AuthProfile create(AuthProfileTO authProfileTO) {
        AuthProfile authProfile = (AuthProfile)this.entityFactory.newEntity(AuthProfile.class);
        authProfile.setOwner(authProfileTO.getOwner());
        return this.update(authProfile, authProfileTO);
    }

    public AuthProfile update(AuthProfile authProfile, AuthProfileTO authProfileTO) {
        authProfile.setImpersonationAccounts(authProfileTO.getImpersonationAccounts());
        authProfile.setGoogleMfaAuthTokens(authProfileTO.getGoogleMfaAuthTokens());
        authProfile.setGoogleMfaAuthAccounts(authProfileTO.getGoogleMfaAuthAccounts());
        authProfile.setU2FRegisteredDevices(authProfileTO.getU2FRegisteredDevices());
        authProfile.setMfaTrustedDevices(authProfileTO.getMfaTrustedDevices());
        authProfile.setWebAuthnDeviceCredentials(authProfileTO.getWebAuthnDeviceCredentials());
        return authProfile;
    }
}

