/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import lombok.Generated;
import net.shibboleth.tool.xmlsectool.XMLSecTool;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.support.saml.idp.metadata.generator.BaseSamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FileSystemSamlIdPMetadataGenerator
extends BaseSamlIdPMetadataGenerator
implements InitializingBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemSamlIdPMetadataGenerator.class);

    public FileSystemSamlIdPMetadataGenerator(SamlIdPMetadataGeneratorConfigurationContext context) {
        super(context);
    }

    @Override
    public Pair<String, String> buildSelfSignedEncryptionCert(Optional<SamlRegisteredService> registeredService) throws Exception {
        File encCert = this.getConfigurationContext().getSamlIdPMetadataLocator().getEncryptionCertificate(registeredService).getFile();
        File encKey = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveEncryptionKey(registeredService).getFile();
        this.writeCertificateAndKey(encCert, encKey, registeredService);
        return Pair.of((Object)FileUtils.readFileToString((File)encCert, (Charset)StandardCharsets.UTF_8), (Object)FileUtils.readFileToString((File)encKey, (Charset)StandardCharsets.UTF_8));
    }

    @Override
    public Pair<String, String> buildSelfSignedSigningCert(Optional<SamlRegisteredService> registeredService) throws Exception {
        File signingCert = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveSigningCertificate(registeredService).getFile();
        File signingKey = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveSigningKey(registeredService).getFile();
        this.writeCertificateAndKey(signingCert, signingKey, registeredService);
        return Pair.of((Object)FileUtils.readFileToString((File)signingCert, (Charset)StandardCharsets.UTF_8), (Object)FileUtils.readFileToString((File)signingKey, (Charset)StandardCharsets.UTF_8));
    }

    @Override
    protected String writeMetadata(String metadata, Optional<SamlRegisteredService> registeredService) throws Exception {
        File metadataFile = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveMetadata(registeredService).getFile();
        FileUtils.write((File)metadataFile, (CharSequence)metadata, (Charset)StandardCharsets.UTF_8);
        SamlIdPMetadataProperties mdProps = this.getConfigurationContext().getCasProperties().getAuthn().getSamlIdp().getMetadata();
        if (mdProps.getFileSystem().isSignMetadata()) {
            File signingCert = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveSigningCertificate(registeredService).getFile();
            File signingKey = this.getConfigurationContext().getSamlIdPMetadataLocator().resolveSigningKey(registeredService).getFile();
            String[] args = new String[]{"--sign", "--referenceIdAttributeName", "ID", "--signatureAlgorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "--inFile", metadataFile.getCanonicalPath(), "--certificate", signingCert.getCanonicalPath(), "--keyFile", signingKey.getCanonicalPath(), "--outFile", metadataFile.getCanonicalPath()};
            XMLSecTool.main((String[])args);
        }
        return metadata;
    }

    protected void writeCertificateAndKey(File certificate, File key, Optional<SamlRegisteredService> registeredService) throws Exception {
        if (certificate.exists()) {
            LOGGER.info("Certificate file [{}] already exists, and will be deleted", (Object)certificate.getCanonicalPath());
            FileUtils.forceDelete((File)certificate);
        }
        if (key.exists()) {
            LOGGER.info("Key file [{}] already exists, and will be deleted", (Object)key.getCanonicalPath());
            FileUtils.forceDelete((File)key);
        }
        try (BufferedWriter keyWriter = Files.newBufferedWriter(key.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
             BufferedWriter certWriter = Files.newBufferedWriter(certificate.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.getConfigurationContext().getSamlIdPCertificateAndKeyWriter().writeCertificateAndKey(keyWriter, certWriter);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.generate(Optional.empty());
    }

    public void initialize() throws Exception {
        this.getConfigurationContext().getSamlIdPMetadataLocator().initialize();
        this.generate(Optional.empty());
    }
}

