/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util.io;

import java.io.BufferedInputStream;
import java.io.InputStream;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.common.engine.impl.util.io.StreamSource;

public class ResourceStreamSource
implements StreamSource {
    String resource;
    ClassLoader classLoader;

    public ResourceStreamSource(String resource) {
        this.resource = resource;
    }

    public ResourceStreamSource(String resource, ClassLoader classLoader) {
        this.resource = resource;
        this.classLoader = classLoader;
    }

    public InputStream getInputStream() {
        InputStream inputStream = null;
        inputStream = this.classLoader == null ? ReflectUtil.getResourceAsStream((String)this.resource) : this.classLoader.getResourceAsStream(this.resource);
        if (inputStream == null) {
            throw new FlowableIllegalArgumentException("resource '" + this.resource + "' doesn't exist");
        }
        return new BufferedInputStream(inputStream);
    }

    public String toString() {
        return "Resource[" + this.resource + "]";
    }
}

