/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class DomainPoolModalPanel
extends AbstractModalPanel<Domain> {
    private static final long serialVersionUID = -2676426626979352532L;
    @SpringBean
    private DomainOps domainOps;
    private final Domain domain;

    public DomainPoolModalPanel(Domain domain, BaseModal<Domain> modal, PageReference pageRef) {
        super(modal, pageRef);
        this.domain = domain;
        this.add(new Component[]{new AjaxNumberFieldPanel.Builder().min((Number)0).build("poolMaxActive", "poolMaxActive", Integer.class, (IModel)new PropertyModel((Object)domain, "poolMaxActive")).setRequired(true)});
        this.add(new Component[]{new AjaxNumberFieldPanel.Builder().min((Number)0).build("poolMinIdle", "poolMinIdle", Integer.class, (IModel)new PropertyModel((Object)domain, "poolMinIdle")).setRequired(true)});
    }

    @Override
    public Domain getItem() {
        return this.domain;
    }

    @Override
    public void onSubmit(AjaxRequestTarget target) {
        try {
            this.domainOps.adjustPoolSize(this.domain.getKey(), this.domain.getPoolMaxActive(), this.domain.getPoolMinIdle());
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While updating domain", (Throwable)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

