/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import java.util.Map;
import lombok.Generated;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityUniversalPromptCredential;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityAuthenticationWebflowAction;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderBean;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.mfa.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DuoSecurityUniversalPromptValidateLoginAction
extends DuoSecurityAuthenticationWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityUniversalPromptValidateLoginAction.class);
    static final String REQUEST_PARAMETER_CODE = "duo_code";
    static final String REQUEST_PARAMETER_STATE = "state";
    private final TicketRegistry ticketRegistry;
    private final MultifactorAuthenticationProviderBean<DuoSecurityMultifactorAuthenticationProvider, DuoSecurityMultifactorAuthenticationProperties> duoProviderBean;
    private final AuthenticationSystemSupport authenticationSystemSupport;

    public DuoSecurityUniversalPromptValidateLoginAction(CasWebflowEventResolver duoAuthenticationWebflowEventResolver, TicketRegistry ticketRegistry, MultifactorAuthenticationProviderBean duoProviderBean, AuthenticationSystemSupport authenticationSystemSupport) {
        super(duoAuthenticationWebflowEventResolver);
        this.ticketRegistry = ticketRegistry;
        this.duoProviderBean = duoProviderBean;
        this.authenticationSystemSupport = authenticationSystemSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Event doExecute(RequestContext requestContext) throws Exception {
        ParameterMap requestParameters = requestContext.getRequestParameters();
        if (requestParameters.contains(REQUEST_PARAMETER_CODE) && requestParameters.contains(REQUEST_PARAMETER_STATE)) {
            String duoState = (String)requestParameters.get(REQUEST_PARAMETER_STATE, String.class);
            LOGGER.trace("Received Duo Security state [{}]", (Object)duoState);
            TransientSessionTicket ticket = null;
            try {
                ticket = (TransientSessionTicket)this.ticketRegistry.getTicket(duoState, TransientSessionTicket.class);
                Authentication authentication = (Authentication)ticket.getProperty(Authentication.class.getSimpleName(), Authentication.class);
                this.populateContextWithCredential(requestContext, ticket, authentication);
                this.populateContextWithAuthentication(requestContext, ticket);
                this.populateContextWithService(requestContext, ticket);
                Event event = super.doExecute(requestContext);
                return event;
            }
            catch (Exception e) {
                LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
                Event event = new EventFactorySupport().event((Object)this, "error");
                return event;
            }
            finally {
                if (ticket != null) {
                    Map flowScope = (Map)ticket.getProperty(MutableAttributeMap.class.getSimpleName(), Map.class);
                    flowScope.forEach((key, value) -> requestContext.getFlowScope().put(key.toString(), value));
                    Credential credential = (Credential)ticket.getProperty(Credential.class.getSimpleName(), Credential.class);
                    WebUtils.putCredential((RequestContext)requestContext, (Credential)credential);
                }
                this.ticketRegistry.deleteTicket(duoState);
            }
        }
        return new EventFactorySupport().event((Object)this, "skip");
    }

    protected void populateContextWithService(RequestContext requestContext, TransientSessionTicket ticket) {
        RegisteredService registeredService = (RegisteredService)ticket.getProperty(RegisteredService.class.getSimpleName(), RegisteredService.class);
        WebUtils.putRegisteredService((RequestContext)requestContext, (RegisteredService)registeredService);
        WebUtils.putServiceIntoFlowScope((RequestContext)requestContext, (Service)ticket.getService());
    }

    protected void populateContextWithCredential(RequestContext requestContext, TransientSessionTicket ticket, Authentication authentication) {
        ParameterMap requestParameters = requestContext.getRequestParameters();
        String duoCode = (String)requestParameters.get(REQUEST_PARAMETER_CODE, String.class);
        LOGGER.trace("Received Duo Security code [{}]", (Object)duoCode);
        String duoSecurityIdentifier = (String)ticket.getProperty("duoProviderId", String.class);
        DuoSecurityUniversalPromptCredential credential = new DuoSecurityUniversalPromptCredential(duoCode, authentication);
        DuoSecurityMultifactorAuthenticationProvider provider = (DuoSecurityMultifactorAuthenticationProvider)this.duoProviderBean.getProvider(duoSecurityIdentifier);
        credential.setProviderId(provider.getId());
        WebUtils.putCredential((RequestContext)requestContext, (Credential)credential);
    }

    protected void populateContextWithAuthentication(RequestContext requestContext, TransientSessionTicket ticket) {
        AuthenticationResultBuilder authenticationResultBuilder = (AuthenticationResultBuilder)ticket.getProperty(AuthenticationResultBuilder.class.getSimpleName(), AuthenticationResultBuilder.class);
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)authenticationResultBuilder, (RequestContext)requestContext);
        AuthenticationResult authenticationResult = authenticationResultBuilder.build(this.authenticationSystemSupport.getPrincipalElectionStrategy());
        WebUtils.putAuthenticationResult((AuthenticationResult)authenticationResult, (RequestContext)requestContext);
        WebUtils.putAuthentication((Authentication)authenticationResult.getAuthentication(), (RequestContext)requestContext);
    }
}

