/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.application;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.application.ProvisioningConnection;
import com.okta.sdk.resource.application.ProvisioningConnectionAuthScheme;
import com.okta.sdk.resource.application.ProvisioningConnectionStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultProvisioningConnection
extends AbstractInstanceResource<ProvisioningConnection>
implements ProvisioningConnection {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final EnumProperty<ProvisioningConnectionAuthScheme> authSchemeProperty = new EnumProperty<ProvisioningConnectionAuthScheme>("authScheme", ProvisioningConnectionAuthScheme.class);
    private static final EnumProperty<ProvisioningConnectionStatus> statusProperty = new EnumProperty<ProvisioningConnectionStatus>("status", ProvisioningConnectionStatus.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultProvisioningConnection.createPropertyDescriptorMap(linksProperty, authSchemeProperty, statusProperty);

    public DefaultProvisioningConnection(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultProvisioningConnection(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return ProvisioningConnection.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public ProvisioningConnectionAuthScheme getAuthScheme() {
        return this.getEnumProperty(authSchemeProperty);
    }

    public ProvisioningConnection setAuthScheme(ProvisioningConnectionAuthScheme authScheme) {
        this.setProperty(authSchemeProperty, (Object)authScheme);
        return this;
    }

    public ProvisioningConnectionStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public ProvisioningConnection setStatus(ProvisioningConnectionStatus status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public void activateDefaultProvisioningConnectionForApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/connections/default/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public ProvisioningConnection getDefaultProvisioningConnectionForApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().getResource("/api/v1/apps/" + appId + "/connections/default", ProvisioningConnection.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivateDefaultProvisioningConnectionForApplication(String appId) {
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/apps/" + appId + "/connections/default/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

