/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageSerializer;

@NotThreadSafe
public class StorageRecord<Type> {
    private long version = 1L;
    private String value;
    private Long expiration;

    public StorageRecord(@Nonnull @NotEmpty String val, @Nullable Long exp) {
        this.value = val;
        this.expiration = exp;
    }

    public long getVersion() {
        return this.version;
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    @Nonnull
    public Type getValue(@Nonnull StorageSerializer<Type> serializer, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        return serializer.deserialize(this.version, context, key, this.value, this.expiration);
    }

    @Nullable
    public Long getExpiration() {
        return this.expiration;
    }

    protected void setVersion(long ver) {
        this.version = Constraint.isGreaterThan((long)0L, (long)ver, (String)"Version must be greater than zero");
    }

    protected void setValue(@Nonnull @NotEmpty String val) {
        this.value = val;
    }

    protected void setValue(@Nonnull Type instance, @Nonnull StorageSerializer<Type> serializer) throws IOException {
        this.value = serializer.serialize(instance);
    }

    protected void setExpiration(@Nullable Long exp) {
        this.expiration = exp;
    }

    protected long incrementVersion() {
        return ++this.version;
    }
}

