/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor.opt;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptNode;

public abstract class CostEstimator {
    protected static final Log LOG = LogFactory.getLog((String)CostEstimator.class.getName());
    public static final double DEFAULT_EST_PARALLELISM = 1.0;
    public static final long FACTOR_NUM_ITERATIONS = 10L;
    public static final double DEFAULT_TIME_ESTIMATE = 5.0;
    public static final double DEFAULT_MEM_ESTIMATE_CP = 1024.0;
    public static final double DEFAULT_MEM_ESTIMATE_SP = 2.097152E7;
    protected boolean _inclCondPart = false;
    protected Collection<String> _exclVars = null;
    protected ExcludeType _exclType = ExcludeType.NONE;

    public abstract double getLeafNodeEstimate(TestMeasure var1, OptNode var2);

    public abstract double getLeafNodeEstimate(TestMeasure var1, OptNode var2, LopProperties.ExecType var3);

    public double getEstimate(TestMeasure measure, OptNode node) {
        return this.getEstimate(measure, node, null);
    }

    public double getEstimate(TestMeasure measure, OptNode node, boolean inclCondPart) {
        this._inclCondPart = inclCondPart;
        double val = this.getEstimate(measure, node, null);
        this._inclCondPart = false;
        return val;
    }

    public double getEstimate(TestMeasure measure, OptNode node, boolean inclCondPart, Collection<String> vars, ExcludeType extype) {
        this._inclCondPart = inclCondPart;
        this._exclVars = vars;
        this._exclType = extype;
        double val = this.getEstimate(measure, node, null);
        this._inclCondPart = false;
        this._exclVars = null;
        this._exclType = ExcludeType.NONE;
        return val;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getEstimate(TestMeasure measure, OptNode node, LopProperties.ExecType et) {
        double val = -1.0;
        if (node.isLeaf()) {
            if (this._inclCondPart && node.getParam(OptNode.ParamType.DATA_PARTITION_COND_MEM) != null) {
                return Double.parseDouble(node.getParam(OptNode.ParamType.DATA_PARTITION_COND_MEM));
            }
            if (et == null) return this.getLeafNodeEstimate(measure, node);
            return this.getLeafNodeEstimate(measure, node, et);
        }
        String tmp = null;
        double N = -1.0;
        block0 : switch (measure) {
            case EXEC_TIME: {
                switch (node.getNodeType()) {
                    case GENERIC: 
                    case FUNCCALL: {
                        return this.getSumEstimate(measure, node.getChilds(), et);
                    }
                    case IF: {
                        if (node.getChilds().size() != 2) return this.getMaxEstimate(measure, node.getChilds(), et);
                        return this.getWeightedEstimate(measure, node.getChilds(), et);
                    }
                    case WHILE: {
                        return 10.0 * this.getSumEstimate(measure, node.getChilds(), et);
                    }
                    case FOR: {
                        tmp = node.getParam(OptNode.ParamType.NUM_ITERATIONS);
                        N = tmp != null ? (double)Long.parseLong(tmp) : 10.0;
                        return N * this.getSumEstimate(measure, node.getChilds(), et);
                    }
                    case PARFOR: {
                        tmp = node.getParam(OptNode.ParamType.NUM_ITERATIONS);
                        N = tmp != null ? (double)Long.parseLong(tmp) : 10.0;
                        return N * this.getSumEstimate(measure, node.getChilds(), et) / (double)Math.max(node.getK(), 1);
                    }
                }
                return val;
            }
            case MEMORY_USAGE: {
                switch (node.getNodeType()) {
                    case GENERIC: 
                    case FUNCCALL: 
                    case IF: 
                    case WHILE: 
                    case FOR: {
                        val = this.getMaxEstimate(measure, node.getChilds(), et);
                        break block0;
                    }
                    case PARFOR: {
                        if (node.getExecType() == OptNode.ExecType.SPARK) {
                            val = this.getMaxEstimate(measure, node.getChilds(), et);
                            break block0;
                        }
                        if (node.getExecType() != OptNode.ExecType.CP) {
                            if (node.getExecType() != null) return val;
                        }
                        val = this.getMaxEstimate(measure, node.getChilds(), et) * (double)Math.max(node.getK(), 1);
                        break block0;
                    }
                }
            }
        }
        return val;
    }

    protected double getDefaultEstimate(TestMeasure measure) {
        switch (measure) {
            case EXEC_TIME: {
                return 5.0;
            }
            case MEMORY_USAGE: {
                return 1024.0;
            }
        }
        return -1.0;
    }

    protected double getMaxEstimate(TestMeasure measure, ArrayList<OptNode> nodes, LopProperties.ExecType et) {
        return nodes.stream().mapToDouble(n -> this.getEstimate(measure, (OptNode)n, et)).max().orElse(Double.NEGATIVE_INFINITY);
    }

    protected double getSumEstimate(TestMeasure measure, ArrayList<OptNode> nodes, LopProperties.ExecType et) {
        return nodes.stream().mapToDouble(n -> this.getEstimate(measure, (OptNode)n, et)).sum();
    }

    protected double getWeightedEstimate(TestMeasure measure, ArrayList<OptNode> nodes, LopProperties.ExecType et) {
        return nodes.stream().mapToDouble(n -> this.getEstimate(measure, (OptNode)n, et)).sum() / (double)nodes.size();
    }

    public static enum ExcludeType {
        NONE,
        SHARED_READ,
        RESULT_LIX;

    }

    public static enum DataFormat {
        DENSE,
        SPARSE;

    }

    public static enum TestMeasure {
        EXEC_TIME,
        MEMORY_USAGE;

    }
}

