/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.ReaderColumnSelectionDense;
import org.apache.sysds.runtime.compress.ReaderColumnSelectionSparse;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.compress.utils.Bitmap;
import org.apache.sysds.runtime.compress.utils.BitmapLossy;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayIntListHashMap;
import org.apache.sysds.runtime.compress.utils.DoubleIntListHashMap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class BitmapEncoder {
    private static final Log LOG = LogFactory.getLog((String)BitmapEncoder.class.getName());

    public static ABitmap extractBitmap(int[] colIndices, MatrixBlock rawBlock, CompressionSettings compSettings) {
        Bitmap res = null;
        if (colIndices.length == 1) {
            res = BitmapEncoder.extractBitmap(colIndices[0], rawBlock, compSettings);
        } else {
            ReaderColumnSelection reader = null;
            reader = rawBlock.isInSparseFormat() && compSettings.transposeInput ? new ReaderColumnSelectionSparse(rawBlock, colIndices, compSettings) : new ReaderColumnSelectionDense(rawBlock, colIndices, compSettings);
            res = BitmapEncoder.extractBitmap(colIndices, rawBlock, reader);
        }
        if (compSettings.lossy) {
            return BitmapEncoder.makeBitmapLossy(res);
        }
        return res;
    }

    private static Bitmap extractBitmap(int colIndex, MatrixBlock rawBlock, CompressionSettings compSettings) {
        int numZeros;
        DoubleIntListHashMap distinctVals;
        block6: {
            int m;
            block5: {
                distinctVals = new DoubleIntListHashMap();
                m = compSettings.transposeInput ? rawBlock.getNumColumns() : rawBlock.getNumRows();
                numZeros = 0;
                if (!rawBlock.isInSparseFormat() || !compSettings.transposeInput) break block5;
                SparseBlock a = rawBlock.getSparseBlock();
                if (a == null || a.isEmpty(colIndex)) break block6;
                int apos = a.pos(colIndex);
                int alen = a.size(colIndex);
                numZeros = m - alen;
                int[] aix = a.indexes(colIndex);
                double[] avals = a.values(colIndex);
                for (int j = apos; j < apos + alen; ++j) {
                    IntArrayList lstPtr = distinctVals.get(avals[j]);
                    if (lstPtr == null) {
                        lstPtr = new IntArrayList();
                        distinctVals.appendValue(avals[j], lstPtr);
                    }
                    lstPtr.appendValue(aix[j]);
                }
                break block6;
            }
            for (int i = 0; i < m; ++i) {
                double val;
                double d = val = compSettings.transposeInput ? rawBlock.quickGetValue(colIndex, i) : rawBlock.quickGetValue(i, colIndex);
                if (val != 0.0) {
                    IntArrayList lstPtr = distinctVals.get(val);
                    if (lstPtr == null) {
                        lstPtr = new IntArrayList();
                        distinctVals.appendValue(val, lstPtr);
                    }
                    lstPtr.appendValue(i);
                    continue;
                }
                ++numZeros;
            }
        }
        return BitmapEncoder.makeBitmap(distinctVals, numZeros);
    }

    private static Bitmap extractBitmap(int[] colIndices, MatrixBlock rawBlock, ReaderColumnSelection rowReader) {
        DblArrayIntListHashMap distinctVals = new DblArrayIntListHashMap();
        DblArray cellVals = null;
        int zero = 0;
        while ((cellVals = rowReader.nextRow()) != null) {
            IntArrayList lstPtr = distinctVals.get(cellVals);
            if (lstPtr == null) {
                lstPtr = new IntArrayList();
                distinctVals.appendValue(new DblArray(cellVals), lstPtr);
            }
            zero += DblArray.isZero(cellVals) ? 1 : 0;
            lstPtr.appendValue(rowReader.getCurrentRowIndex());
        }
        return BitmapEncoder.makeBitmap(distinctVals, colIndices.length, zero);
    }

    private static Bitmap makeBitmap(DblArrayIntListHashMap distinctVals, int numColumns, int numZeros) {
        int numVals = distinctVals.size();
        int numCols = numColumns;
        double[] values = new double[numVals * numCols];
        IntArrayList[] offsetsLists = new IntArrayList[numVals];
        int bitmapIx = 0;
        for (DblArrayIntListHashMap.DArrayIListEntry val : distinctVals.extractValues()) {
            System.arraycopy(val.key.getData(), 0, values, bitmapIx * numCols, numCols);
            offsetsLists[bitmapIx++] = val.value;
        }
        return new Bitmap(numCols, offsetsLists, numZeros, values);
    }

    private static Bitmap makeBitmap(DoubleIntListHashMap distinctVals, int numZeros) {
        int numVals = distinctVals.size();
        double[] values = new double[numVals];
        IntArrayList[] offsetsLists = new IntArrayList[numVals];
        int bitmapIx = 0;
        for (DoubleIntListHashMap.DIListEntry val : distinctVals.extractValues()) {
            values[bitmapIx] = val.key;
            offsetsLists[bitmapIx++] = val.value;
        }
        return new Bitmap(1, offsetsLists, numZeros, values);
    }

    private static ABitmap makeBitmapLossy(Bitmap ubm) {
        double[] fp = ubm.getValues();
        if (fp.length == 0) {
            return ubm;
        }
        Stats stats = new Stats(fp);
        if (Double.isInfinite(stats.max) || Double.isInfinite(stats.min)) {
            LOG.warn((Object)"Defaulting to incompressable colGroup");
            return ubm;
        }
        return BitmapEncoder.make8BitLossy(ubm, stats);
    }

    private static BitmapLossy make8BitLossy(Bitmap ubm, Stats stats) {
        double[] fp = ubm.getValues();
        int numCols = ubm.getNumColumns();
        double scale = Math.max(Math.abs(stats.min), stats.max) / 127.0;
        byte[] scaledValues = BitmapEncoder.scaleValues(fp, scale);
        if (numCols == 1) {
            return BitmapEncoder.makeBitmapLossySingleCol(ubm, scaledValues, scale);
        }
        return BitmapEncoder.makeBitmapLossyMultiCol(ubm, scaledValues, scale);
    }

    private static BitmapLossy makeBitmapLossySingleCol(Bitmap ubm, byte[] scaledValues, double scale) {
        LinkedHashMap values = new LinkedHashMap();
        HashMap<Byte, Integer> lengths = new HashMap<Byte, Integer>();
        IntArrayList[] fullSizeOffsetsLists = ubm.getOffsetList();
        int numZeroGroups = ubm.getZeroCounts();
        for (int idx = 0; idx < scaledValues.length; ++idx) {
            if (scaledValues[idx] != 0) {
                if (values.containsKey(scaledValues[idx])) {
                    ((Queue)values.get(scaledValues[idx])).add(fullSizeOffsetsLists[idx]);
                    lengths.put(scaledValues[idx], (Integer)lengths.get(scaledValues[idx]) + fullSizeOffsetsLists[idx].size());
                    continue;
                }
                LinkedList<IntArrayList> offsets = new LinkedList<IntArrayList>();
                offsets.add(fullSizeOffsetsLists[idx]);
                values.put(scaledValues[idx], offsets);
                lengths.put(scaledValues[idx], fullSizeOffsetsLists[idx].size());
                continue;
            }
            ++numZeroGroups;
        }
        byte[] scaledValuesReduced = new byte[values.keySet().size()];
        IntArrayList[] newOffsetsLists = new IntArrayList[values.keySet().size()];
        Iterator x = values.entrySet().iterator();
        int idx = 0;
        while (x.hasNext()) {
            Map.Entry ent = x.next();
            scaledValuesReduced[idx] = (Byte)ent.getKey();
            Queue q = (Queue)ent.getValue();
            newOffsetsLists[idx] = q.size() == 1 ? (IntArrayList)q.remove() : BitmapEncoder.mergeOffsets(q, new int[((Integer)lengths.get(ent.getKey())).intValue()]);
            ++idx;
        }
        return new BitmapLossy(ubm.getNumColumns(), newOffsetsLists, numZeroGroups, scaledValuesReduced, scale);
    }

    private static BitmapLossy makeBitmapLossyMultiCol(Bitmap ubm, byte[] scaledValues, double scale) {
        int numColumns = ubm.getNumColumns();
        HashMap values = new HashMap();
        HashMap lengths = new HashMap();
        IntArrayList[] fullSizeOffsetsLists = ubm.getOffsetList();
        int numZeroGroups = ubm.getZeroCounts();
        boolean allZero = true;
        for (int idx = 0; idx < scaledValues.length; idx += numColumns) {
            ArrayList<Byte> array = new ArrayList<Byte>();
            for (int off = 0; off < numColumns; ++off) {
                allZero = scaledValues[idx + off] == 0 && allZero;
                array.add(scaledValues[idx + off]);
            }
            numZeroGroups += allZero ? 1 : 0;
            if (!allZero) {
                if (values.containsKey(array)) {
                    ((Queue)values.get(array)).add(fullSizeOffsetsLists[idx / numColumns]);
                    lengths.put(array, (Integer)lengths.get(array) + fullSizeOffsetsLists[idx / numColumns].size());
                } else {
                    LinkedList<IntArrayList> offsets = new LinkedList<IntArrayList>();
                    offsets.add(fullSizeOffsetsLists[idx / numColumns]);
                    values.put(array, offsets);
                    lengths.put(array, fullSizeOffsetsLists[idx / numColumns].size());
                }
            }
            allZero = true;
        }
        byte[] scaledValuesReduced = new byte[values.keySet().size() * numColumns];
        IntArrayList[] newOffsetsLists = new IntArrayList[values.keySet().size()];
        Iterator x = values.entrySet().iterator();
        int idx = 0;
        while (x.hasNext()) {
            Map.Entry ent = x.next();
            List key = (List)ent.getKey();
            int row = idx * numColumns;
            for (int off = 0; off < numColumns; ++off) {
                scaledValuesReduced[row + off] = (Byte)key.get(off);
            }
            Queue q = (Queue)ent.getValue();
            newOffsetsLists[idx] = BitmapEncoder.mergeOffsets(q, new int[((Integer)lengths.get(key)).intValue()]);
            ++idx;
        }
        return new BitmapLossy(ubm.getNumColumns(), newOffsetsLists, numZeroGroups, scaledValuesReduced, scale);
    }

    private static IntArrayList mergeOffsets(Queue<IntArrayList> offsets, int[] res) {
        int indexStart = 0;
        while (!offsets.isEmpty()) {
            IntArrayList h = offsets.remove();
            int[] v = h.extractValues();
            for (int i = 0; i < h.size(); ++i) {
                res[indexStart++] = v[i];
            }
        }
        Arrays.sort(res);
        return new IntArrayList(res);
    }

    private static byte[] scaleValues(double[] fp, double scale) {
        byte[] res = new byte[fp.length];
        for (int idx = 0; idx < fp.length; ++idx) {
            res[idx] = (byte)Math.round(fp[idx] / scale);
        }
        return res;
    }

    private static class Stats {
        protected double max;
        protected double min;
        protected double minDelta;
        protected double maxDelta;
        protected boolean sameDelta;

        public Stats(double[] fp) {
            this.max = fp[fp.length - 1];
            this.min = fp[0];
            this.minDelta = Double.POSITIVE_INFINITY;
            this.maxDelta = Double.NEGATIVE_INFINITY;
            this.sameDelta = true;
            if (fp.length > 1) {
                double delta = fp[0] - fp[1];
                for (int i = 0; i < fp.length - 1; ++i) {
                    double ndelta = fp[i] - fp[i + 1];
                    if (delta < this.minDelta) {
                        this.minDelta = delta;
                    }
                    if (delta > this.maxDelta) {
                        this.maxDelta = delta;
                    }
                    if (this.sameDelta && Math.abs(delta - ndelta) <= delta * 1.0E-8) {
                        this.sameDelta = false;
                    }
                    delta = ndelta;
                }
            }
        }
    }
}

