/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionDenseSample
extends ReaderColumnSelection {
    protected MatrixBlock _data;
    private int[] _sampleIndexes;
    private int lastIndex = -1;
    private DblArray reusableReturn;
    private double[] reusableArr;

    public ReaderColumnSelectionDenseSample(MatrixBlock data, int[] colIndexes, int[] sampleIndexes, CompressionSettings compSettings) {
        super(colIndexes, -1, compSettings);
        this._data = data;
        this._sampleIndexes = sampleIndexes;
        this.reusableArr = new double[colIndexes.length];
        this.reusableReturn = new DblArray(this.reusableArr);
    }

    @Override
    protected DblArray getNextRow() {
        if (this.lastIndex == this._sampleIndexes.length - 1) {
            return null;
        }
        ++this.lastIndex;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            this.reusableArr[i] = this._compSettings.transposeInput ? this._data.quickGetValue(this._colIndexes[i], this._sampleIndexes[this.lastIndex]) : this._data.quickGetValue(this._sampleIndexes[this.lastIndex], this._colIndexes[i]);
        }
        return this.reusableReturn;
    }

    @Override
    public int getCurrentRowIndex() {
        return this._sampleIndexes[this.lastIndex];
    }
}

