/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.TfUtils;
import org.apache.sysds.runtime.transform.encode.Encoder;
import org.apache.sysds.runtime.transform.meta.TfMetaUtils;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class EncoderFeatureHash
extends Encoder {
    private static final long serialVersionUID = 7435806042138687342L;
    private long _K;

    public EncoderFeatureHash(JSONObject parsedSpec, String[] colnames, int clen, int minCol, int maxCol) throws JSONException {
        super(null, clen);
        this._colList = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, TfUtils.TfMethod.HASH.toString(), minCol, maxCol);
        this._K = EncoderFeatureHash.getK(parsedSpec);
    }

    public EncoderFeatureHash(int[] colList, int clen, long K) {
        super(colList, clen);
        this._K = K;
    }

    public EncoderFeatureHash() {
        super(new int[0], 0);
        this._K = 0L;
    }

    private static long getK(JSONObject parsedSpec) throws JSONException {
        return parsedSpec.getLong("K");
    }

    private long getCode(String key) {
        return (long)key.hashCode() % this._K;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        if (!this.isApplicable()) {
            return out;
        }
        this.apply(in, out);
        return out;
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            for (int i = 0; i < in.getNumRows(); ++i) {
                Object okey = in.get(i, colID - 1);
                String key = okey != null ? okey.toString() : null;
                long code = this.getCode(key);
                out.quickSetValue(i, colID - 1, code >= 0L ? (double)code : Double.NaN);
            }
        }
        return out;
    }

    @Override
    public Encoder subRangeEncoder(IndexRange ixRange) {
        int[] colList = this.subRangeColList(ixRange);
        if (colList.length == 0) {
            return null;
        }
        return new EncoderFeatureHash(colList, (int)ixRange.colSpan(), this._K);
    }

    @Override
    public void mergeAt(Encoder other, int row, int col) {
        if (other instanceof EncoderFeatureHash) {
            this.mergeColumnInfo(other, col);
            if (((EncoderFeatureHash)other)._K != 0L && this._K == 0L) {
                this._K = ((EncoderFeatureHash)other)._K;
            }
            return;
        }
        super.mergeAt(other, row, col);
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        if (!this.isApplicable()) {
            return meta;
        }
        meta.ensureAllocatedColumns(1);
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            meta.set(0, colID - 1, String.valueOf(this._K));
        }
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || meta.getNumRows() <= 0) {
            return;
        }
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            this._K = UtilFunctions.parseToLong(meta.get(0, colID - 1).toString());
        }
    }
}

