#-------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
# 
#   http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
#-------------------------------------------------------------


args <- commandArgs(TRUE)
options(digits=22)

library("Matrix")

A <- as.matrix(readMM(paste(args[1], "A.mtx", sep="")))
A <- floor(A);

IA = (A != 0) * seq (1, nrow (A), 1);
IA = matrix (IA, (nrow (A) * ncol(A)), 1, byrow = FALSE);
VA = matrix ( A, (nrow (A) * ncol(A)), 1, byrow = FALSE);
#IA = removeEmpty (target = IA, margin = "rows");
#VA = removeEmpty (target = VA, margin = "rows");
Btmp1 = table (IA, VA);
Btmp2 = as.matrix(as.data.frame.matrix(Btmp1));

#remove first row and column (0 values, see missing removeEmpty)
B = Btmp2[2:nrow(Btmp2),2:ncol(Btmp2)];

writeMM(as(B, "CsparseMatrix"), paste(args[2], "B", sep="")); 


