/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuaternaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.QuaternaryOperator;

public class QuaternaryWSLossFEDInstruction
extends QuaternaryFEDInstruction {
    protected QuaternaryWSLossFEDInstruction(Operator operator, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, String opcode, String instruction_str) {
        super(FEDInstruction.FEDType.Quaternary, operator, in1, in2, in3, in4, out, opcode, instruction_str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        Future<FederatedResponse>[] response;
        QuaternaryOperator qop = (QuaternaryOperator)this._optr;
        MatrixObject X = ec.getMatrixObject(this.input1);
        MatrixObject U = ec.getMatrixObject(this.input2);
        MatrixObject V = ec.getMatrixObject(this.input3);
        MatrixObject W = null;
        if (qop.hasFourInputs()) {
            W = ec.getMatrixObject(this._input4);
        }
        if (!(!X.isFederated(FederationMap.FType.ROW) || U.isFederated() || V.isFederated() || W != null && W.isFederated())) {
            FederationMap fedMap = X.getFedMapping();
            FederatedRequest[] frInit1 = fedMap.broadcastSliced(U, false);
            FederatedRequest frInit2 = fedMap.broadcast(V);
            FederatedRequest[] frInit3 = null;
            FederatedRequest frCompute1 = null;
            if (W != null) {
                frInit3 = fedMap.broadcastSliced(W, false);
                frCompute1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3, this._input4}, new long[]{fedMap.getID(), frInit1[0].getID(), frInit2.getID(), frInit3[0].getID()});
            } else {
                frCompute1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3}, new long[]{fedMap.getID(), frInit1[0].getID(), frInit2.getID()});
            }
            FederatedRequest frGet1 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, frCompute1.getID());
            FederatedRequest frCleanup1 = fedMap.cleanup(this.getTID(), frCompute1.getID());
            FederatedRequest frCleanup2 = fedMap.cleanup(this.getTID(), frInit1[0].getID());
            FederatedRequest frCleanup3 = fedMap.cleanup(this.getTID(), frInit2.getID());
            if (frInit3 != null) {
                FederatedRequest frCleanup4 = fedMap.cleanup(this.getTID(), frInit3[0].getID());
                fedMap.execute(this.getTID(), true, frInit1, new FederatedRequest[]{frInit2});
                response = fedMap.execute(this.getTID(), true, frInit3, new FederatedRequest[]{frCompute1, frGet1, frCleanup1, frCleanup2, frCleanup3, frCleanup4});
            } else {
                response = fedMap.execute(this.getTID(), true, frInit1, new FederatedRequest[]{frInit2, frCompute1, frGet1, frCleanup1, frCleanup2, frCleanup3});
            }
        } else {
            throw new DMLRuntimeException("Unsupported federated inputs (X, U, V, W) = (" + X.isFederated() + ", " + U.isFederated() + ", " + V.isFederated() + ", " + (W != null ? Boolean.valueOf(W.isFederated()) : "none") + ")");
        }
        AggregateUnaryOperator aop = InstructionUtils.parseBasicAggregateUnaryOperator("uak+");
        ec.setVariable(this.output.getName(), FederationUtils.aggScalar(aop, response));
    }
}

