/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.io.FileFormatPropertiesHDF5;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.io.hdf5.H5;
import org.apache.sysds.runtime.io.hdf5.H5ContiguousDataset;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderHDF5
extends MatrixReader {
    protected final FileFormatPropertiesHDF5 _props;

    public ReaderHDF5(FileFormatPropertiesHDF5 props) {
        this._props = props;
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = null;
        if (rlen >= 0L && clen >= 0L) {
            ret = ReaderHDF5.createOutputMatrixBlock(rlen, clen, (int)rlen, estnnz, true, false);
        }
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        ReaderHDF5.checkValidInputFile(fs, path);
        ret = ReaderHDF5.readHDF5MatrixFromHDFS(path, job, fs, ret, rlen, clen, blen, this._props.getDatasetName());
        ret.examSparsity();
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = ReaderHDF5.createOutputMatrixBlock(rlen, clen, (int)rlen, estnnz, true, false);
        String datasetName = this._props.getDatasetName();
        BufferedInputStream bis = new BufferedInputStream(is, (int)(2048L + clen * rlen * 8L));
        long lnnz = ReaderHDF5.readMatrixFromHDF5(bis, datasetName, ret, 0, rlen, clen, blen);
        ret.setNonZeros(lnnz);
        ret.examSparsity();
        return ret;
    }

    private static MatrixBlock readHDF5MatrixFromHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock dest, long rlen, long clen, int blen, String datasetName) throws IOException, DMLRuntimeException {
        ArrayList<Path> files = new ArrayList<Path>();
        if (fs.isDirectory(path)) {
            for (FileStatus stat : fs.listStatus(path, IOUtilFunctions.hiddenFileFilter)) {
                files.add(stat.getPath());
            }
            Collections.sort(files);
        } else {
            files.add(path);
        }
        if (dest == null) {
            dest = ReaderHDF5.computeHDF5Size(files, fs, datasetName);
            clen = dest.getNumColumns();
            rlen = dest.getNumRows();
        }
        long lnnz = 0L;
        for (int fileNo = 0; fileNo < files.size(); ++fileNo) {
            BufferedInputStream bis = new BufferedInputStream((InputStream)fs.open(files.get(fileNo)), (int)(2048L + clen * rlen * 8L));
            lnnz += ReaderHDF5.readMatrixFromHDF5(bis, datasetName, dest, 0, rlen, clen, blen);
        }
        dest.setNonZeros(lnnz);
        return dest;
    }

    public static long readMatrixFromHDF5(BufferedInputStream bis, String datasetName, MatrixBlock dest, int row, long rlen, long clen, int blen) {
        bis.mark(0);
        long lnnz = 0L;
        H5RootObject rootObject = H5.H5Fopen(bis);
        H5ContiguousDataset contiguousDataset = H5.H5Dopen(rootObject, datasetName);
        int[] dims = rootObject.getDimensions();
        int ncol = dims[1];
        DenseBlock denseBlock = dest.getDenseBlock();
        double[] data = new double[ncol];
        int i = row;
        while ((long)i < rlen) {
            H5.H5Dread(contiguousDataset, i, data);
            for (int j = 0; j < ncol; ++j) {
                if (data[j] == 0.0) continue;
                denseBlock.set(i, j, data[j]);
                ++lnnz;
            }
            ++row;
            ++i;
        }
        IOUtilFunctions.closeSilently(bis);
        return lnnz;
    }

    public static MatrixBlock computeHDF5Size(List<Path> files, FileSystem fs, String datasetName) throws IOException, DMLRuntimeException {
        int nrow = 0;
        int ncol = 0;
        for (int fileNo = 0; fileNo < files.size(); ++fileNo) {
            BufferedInputStream bis = new BufferedInputStream((InputStream)fs.open(files.get(fileNo)));
            H5RootObject rootObject = H5.H5Fopen(bis);
            H5.H5Dopen(rootObject, datasetName);
            int[] dims = rootObject.getDimensions();
            nrow += dims[0];
            ncol += dims[1];
            IOUtilFunctions.closeSilently(bis);
        }
        return ReaderHDF5.createOutputMatrixBlock(nrow, ncol, nrow, (long)nrow * (long)ncol, true, false);
    }
}

