/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLOptions;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.api.jmlc.Connection;
import org.apache.sysds.conf.CompilerConfig;
import py4j.GatewayServer;
import py4j.GatewayServerListener;
import py4j.Py4JNetworkException;
import py4j.Py4JServerConnection;

public class PythonDMLScript {
    private Connection _connection = new Connection(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS, CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS, CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS, CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS, CompilerConfig.ConfigType.PARALLEL_CP_MATRIX_OPERATIONS, CompilerConfig.ConfigType.PARALLEL_LOCAL_OR_REMOTE_PARFOR, CompilerConfig.ConfigType.ALLOW_DYN_RECOMPILATION);

    public static void main(String[] args) throws Exception {
        DMLOptions dmlOptions = DMLOptions.parseCLArguments(args);
        DMLScript.loadConfiguration(dmlOptions.configFile);
        PythonDMLScript.start(dmlOptions.pythonPort);
    }

    private static void start(int port) throws Py4JNetworkException {
        GatewayServer GwS = new GatewayServer((Object)new PythonDMLScript(), port);
        GwS.addListener((GatewayServerListener)new DMLGateWayListener());
        GwS.start();
    }

    private PythonDMLScript() {
    }

    public Connection getConnection() {
        return this._connection;
    }

    protected static class DMLGateWayListener
    implements GatewayServerListener {
        private static final Log LOG = LogFactory.getLog((String)DMLGateWayListener.class.getName());

        protected DMLGateWayListener() {
        }

        public void connectionError(Exception e) {
            LOG.warn((Object)("Connection error: " + e.getMessage()));
            System.exit(1);
        }

        public void connectionStarted(Py4JServerConnection gatewayConnection) {
            LOG.debug((Object)("Connection Started: " + gatewayConnection.toString()));
        }

        public void connectionStopped(Py4JServerConnection gatewayConnection) {
            LOG.debug((Object)("Connection stopped: " + gatewayConnection.toString()));
        }

        public void serverError(Exception e) {
            LOG.error((Object)("Server Error " + e.getMessage()));
        }

        public void serverPostShutdown() {
            LOG.info((Object)"Shutdown done");
            System.exit(0);
        }

        public void serverPreShutdown() {
            LOG.info((Object)"Starting JVM shutdown");
        }

        public void serverStarted() {
            System.out.println("GatewayServer Started");
        }

        public void serverStopped() {
            System.out.println("GatewayServer Stopped");
            System.exit(0);
        }
    }
}

