/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.sysds.common.Builtins;
import org.apache.sysds.common.Types;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.FunctionStatement;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.Identifier;
import org.apache.sysds.parser.IndexedIdentifier;
import org.apache.sysds.parser.ParameterExpression;
import org.apache.sysds.parser.VariableSet;

public class FunctionCallIdentifier
extends DataIdentifier {
    private ArrayList<ParameterExpression> _paramExprs;
    private Expression.FunctCallOp _opcode;
    private String _namespace;

    public void setFunctionName(String functionName) {
        this._name = functionName;
    }

    public void setFunctionNamespace(String passed) {
        this._namespace = passed;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public ArrayList<ParameterExpression> getParamExprs() {
        return this._paramExprs;
    }

    @Override
    public Expression rewriteExpression(String prefix) {
        ArrayList<ParameterExpression> newParameterExpressions = new ArrayList<ParameterExpression>();
        for (ParameterExpression paramExpr : this._paramExprs) {
            newParameterExpressions.add(new ParameterExpression(paramExpr.getName(), paramExpr.getExpr().rewriteExpression(prefix)));
        }
        FunctionCallIdentifier fci = new FunctionCallIdentifier(newParameterExpressions);
        fci.setParseInfo(this);
        fci._name = this._name;
        fci._namespace = this._namespace;
        fci._opcode = this._opcode;
        return fci;
    }

    public FunctionCallIdentifier() {
    }

    public FunctionCallIdentifier(ArrayList<ParameterExpression> paramExpressions) {
        this._paramExprs = paramExpressions;
        this._opcode = null;
    }

    public Expression.FunctCallOp getOpCode() {
        return this._opcode;
    }

    /*
     * WARNING - void declaration
     */
    public void validateExpression(DMLProgram dmlp, HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        void var9_16;
        FunctionStatementBlock fblock;
        if (dmlp.getNamespaces().get(this._namespace) == null) {
            this.raiseValidateError("namespace " + this._namespace + " is not defined ", conditional);
        }
        if ((fblock = dmlp.getFunctionStatementBlock(this._namespace, this._name)) == null) {
            fblock = dmlp.getFunctionStatementBlock(".builtinNS", this._name);
            this._namespace = ".builtinNS";
        }
        if (fblock == null && !Builtins.contains(this._name, true, false)) {
            this.raiseValidateError("function " + this._name + " is undefined in namespace " + this._namespace, conditional);
        }
        this._opcode = Expression.FunctCallOp.INTERNAL;
        boolean hasNamed = false;
        boolean hasUnnamed = false;
        for (ParameterExpression parameterExpression : this._paramExprs) {
            if (parameterExpression.getName() == null) {
                hasUnnamed = true;
                continue;
            }
            hasNamed = true;
        }
        if (hasNamed && hasUnnamed) {
            this.raiseValidateError(" In DML, functions can only have named parameters (e.g., name1=value1, name2=value2) or unnamed parameters (e.g, value1, value2). " + this._name + " has both parameter types.", conditional);
        }
        for (ParameterExpression parameterExpression : this._paramExprs) {
            if (parameterExpression.getExpr() instanceof FunctionCallIdentifier) {
                this.raiseValidateError("UDF function call not supported as parameter to function call", false);
            }
            parameterExpression.getExpr().validateExpression(ids, constVars, conditional);
        }
        if (Builtins.contains(this._name, true, false) && fblock == null) {
            Types.DataType dt = this._paramExprs.get(0).getExpr().getOutput().getDataType();
            this._name = Builtins.getInternalFName(this._name, dt);
            this._namespace = ".builtinNS";
            fblock = dmlp.getFunctionStatementBlock(this._namespace, this._name);
            if (fblock == null) {
                this.raiseValidateError("Builtin function '" + this._name + "': script loaded but function not found. Is there a typo in the function name?");
            }
        }
        FunctionStatement fstmt = (FunctionStatement)fblock.getStatement(0);
        for (Expression expDef : fstmt.getInputDefaults()) {
            if (expDef == null) continue;
            expDef.validateExpression(ids, constVars, conditional);
        }
        if (!conditional) {
            for (ParameterExpression paramExpr : this._paramExprs) {
                Expression expri = paramExpr.getExpr();
                if (!(expri instanceof DataIdentifier) || expri instanceof IndexedIdentifier || !constVars.containsKey(((DataIdentifier)expri).getName())) continue;
                paramExpr.setExpr(constVars.get(((DataIdentifier)expri).getName()));
            }
        }
        if (fstmt.getInputParams().size() < this._paramExprs.size()) {
            this.raiseValidateError("function " + this._name + " has incorrect number of parameters. Function requires " + fstmt.getInputParams().size() + " but was called with " + this._paramExprs.size(), conditional);
        }
        this._outputs = new Identifier[fstmt.getOutputParams().size()];
        boolean bl = false;
        while (var9_16 < fstmt.getOutputParams().size()) {
            this._outputs[var9_16] = new DataIdentifier(fstmt.getOutputParams().get((int)var9_16));
            ++var9_16;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._namespace != null && this._namespace.length() > 0 && !this._namespace.equals(".defaultNS")) {
            sb.append(this._namespace + "::");
        }
        sb.append(this._name);
        sb.append(" ( ");
        for (int i = 0; i < this._paramExprs.size(); ++i) {
            sb.append(this._paramExprs.get(i).toString());
            if (i >= this._paramExprs.size() - 1) continue;
            sb.append(",");
        }
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        for (int i = 0; i < this._paramExprs.size(); ++i) {
            result.addVariables(this._paramExprs.get(i).getExpr().variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        for (int i = 0; i < this._outputs.length; ++i) {
            result.addVariable(((DataIdentifier)this._outputs[i]).getName(), (DataIdentifier)this._outputs[i]);
        }
        return result;
    }

    @Override
    public boolean multipleReturns() {
        return true;
    }
}

