/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.functionobjects;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.matrix.data.CTableMap;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;

public class CTable
extends ValueFunction {
    private static final long serialVersionUID = -5374880447194177236L;
    private static CTable singleObj = null;

    private CTable() {
    }

    public static CTable getCTableFnObject() {
        if (singleObj == null) {
            singleObj = new CTable();
        }
        return singleObj;
    }

    public void execute(double v1, double v2, double w, boolean ignoreZeros, CTableMap resultMap, MatrixBlock resultBlock) {
        if (resultBlock != null) {
            this.execute(v1, v2, w, ignoreZeros, resultBlock);
        } else {
            this.execute(v1, v2, w, ignoreZeros, resultMap);
        }
    }

    public void execute(double v1, double v2, double w, boolean ignoreZeros, CTableMap resultMap) {
        if (Double.isNaN(v1) || Double.isNaN(v2) || Double.isNaN(w)) {
            return;
        }
        long row = UtilFunctions.toLong(v1);
        long col = UtilFunctions.toLong(v2);
        if (ignoreZeros && row == 0L && col == 0L) {
            return;
        }
        if (row <= 0L || col <= 0L) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (one of the value <= zero): " + v1 + " " + v2);
        }
        resultMap.aggregate(row, col, w);
    }

    public void execute(double v1, double v2, double w, boolean ignoreZeros, MatrixBlock ctableResult) {
        if (Double.isNaN(v1) || Double.isNaN(v2) || Double.isNaN(w)) {
            return;
        }
        long row = UtilFunctions.toLong(v1);
        long col = UtilFunctions.toLong(v2);
        if (ignoreZeros && row == 0L && col == 0L) {
            return;
        }
        if (row <= 0L || col <= 0L) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (one of the value <= zero): " + v1 + " " + v2);
        }
        if (row > (long)ctableResult.getNumRows() || col > (long)ctableResult.getNumColumns()) {
            return;
        }
        ctableResult.quickSetValue((int)row - 1, (int)col - 1, ctableResult.quickGetValue((int)row - 1, (int)col - 1) + w);
    }

    public int execute(int row, double v2, double w, int maxCol, MatrixBlock ctableResult) {
        if (Double.isNaN(v2) || Double.isNaN(w)) {
            return maxCol;
        }
        int col = UtilFunctions.toInt(v2);
        if (col <= 0) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (value <= zero): " + v2);
        }
        ctableResult.quickSetValue(row - 1, col - 1, w);
        return Math.max(maxCol, col);
    }

    public Pair<MatrixIndexes, Double> execute(long row, double v2, double w) {
        if (Double.isNaN(v2) || Double.isNaN(w)) {
            return new Pair<MatrixIndexes, Double>(new MatrixIndexes(-1L, -1L), w);
        }
        long col = UtilFunctions.toLong(v2);
        if (col <= 0L) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (value <= zero): " + v2);
        }
        return new Pair<MatrixIndexes, Double>(new MatrixIndexes(row, col), w);
    }
}

