# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/pcaInverse.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def pcaInverse(Y: Matrix,
               Clusters: Matrix,
               Centering: Matrix,
               ScaleFactor: Matrix):
    """
     Principal Component Analysis (PCA) for reconstruction of approximation of the original data.
     This methods allows to reconstruct an approximation of the original matrix, and is useful for
     calculating how much information is lost in the PCA.
    
    
    
    :param Y: Input features that have PCA applied to them
    :param Clusters: The previous PCA components computed
    :param Centering: The column means of the PCA model, subtracted to construct the PCA
    :param ScaleFactor: The scaling of each dimension in the PCA model
    :return: Output feature matrix reconstructing and approximation of the original matrix
    """

    params_dict = {'Y': Y, 'Clusters': Clusters, 'Centering': Centering, 'ScaleFactor': ScaleFactor}
    return Matrix(Y.sds_context,
        'pcaInverse',
        named_input_nodes=params_dict)
